/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Map;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="main-configuration", displayName="Main Configuration", description="Display Camel startup configuration")
public class MainConfigurationDevConsole
extends AbstractDevConsole {
    private final OrderedLocationProperties startupConfiguration = new OrderedLocationProperties();

    public MainConfigurationDevConsole() {
        super("camel", "main-configuration", "Main Configuration", "Display Camel startup configuration");
    }

    public void addStartupConfiguration(OrderedLocationProperties startupConfiguration) {
        this.startupConfiguration.putAll(startupConfiguration);
    }

    public void addStartupConfiguration(String loc, Object key, Object value) {
        this.startupConfiguration.put(loc, key, value);
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (!this.startupConfiguration.isEmpty()) {
            sb.append("Camel Main Configuration:\n");
            for (Map.Entry entry : this.startupConfiguration.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                String loc = LocationHelper.locationSummary(this.startupConfiguration, k);
                if (SensitiveUtils.containsSensitive(k)) {
                    sb.append(String.format("    %s %s = xxxxxx%n", loc, k));
                    continue;
                }
                sb.append(String.format("    %s %s = %s%n", loc, k, v));
            }
        }
        return sb.toString();
    }

    @Override
    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        if (!this.startupConfiguration.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (Map.Entry entry : this.startupConfiguration.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                String loc = this.startupConfiguration.getLocation(k);
                JsonObject jo = new JsonObject();
                jo.put("key", k);
                jo.put("value", v);
                if (loc != null) {
                    jo.put("location", loc);
                    jo.put("internal", MainConfigurationDevConsole.isInternal(loc));
                }
                arr.add(jo);
            }
            root.put("configurations", arr);
        }
        return root;
    }

    private static boolean isInternal(String loc) {
        if (loc == null) {
            return false;
        }
        return "initial".equals(loc) || "override".equals(loc);
    }
}

