/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.MainConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileConfigurer {
    protected static final Logger LOG = LoggerFactory.getLogger(ProfileConfigurer.class);

    public static void configureMain(CamelContext camelContext, String profile2, MainConfigurationProperties config) {
        boolean enabled;
        if (profile2 == null || profile2.isBlank()) {
            return;
        }
        if ("dev".equals(profile2) && !(enabled = config.tracerConfig().isEnabled())) {
            config.tracerConfig().withStandby(true);
        }
        ProfileConfigurer.configureCommon(camelContext, profile2, config);
    }

    public static void configureCommon(CamelContext camelContext, String profile2, DefaultConfigurationProperties<?> config) {
        camelContext.getCamelContextExtension().setProfile(profile2);
        if (profile2 == null || profile2.isBlank()) {
            return;
        }
        if ("dev".equals(profile2)) {
            config.setDevConsoleEnabled(true);
            config.setCamelEventsTimestampEnabled(true);
            config.setLoadHealthChecks(true);
            config.setSourceLocationEnabled(true);
            config.setModeline(true);
            config.setLoadStatisticsEnabled(true);
            config.setMessageHistory(true);
            config.setInflightRepositoryBrowseEnabled(true);
            config.setEndpointRuntimeStatisticsEnabled(true);
            config.setJmxManagementStatisticsLevel(ManagementStatisticsLevel.Extended);
            config.setJmxUpdateRouteEnabled(true);
            config.setShutdownLogInflightExchangesOnTimeout(false);
            config.setShutdownTimeout(10);
            config.setStartupRecorder("backlog");
        }
        if ("prod".equals(profile2)) {
            profile2 = "production";
        }
        LOG.info("The application is starting with profile: {}", (Object)profile2);
    }
}

