/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Main
extends MainCommandLineSupport {
    public static final String LOCATION_PROPERTIES = "META-INF/camel-spring/location.properties";
    protected static Main instance;
    private static final Charset UTF8;
    private String applicationContextUri = "META-INF/spring/*.xml";
    private String fileApplicationContextUri;
    private AbstractApplicationContext applicationContext;
    private AbstractApplicationContext parentApplicationContext;
    private AbstractApplicationContext additionalApplicationContext;
    private String parentApplicationContextUri;
    private boolean allowMultipleCamelContexts;

    public Main() {
        this.standalone = false;
    }

    @Override
    protected void initOptions() {
        super.initOptions();
        this.addOption(new MainCommandLineSupport.ParameterOption("ac", "applicationContext", "Sets the classpath based spring ApplicationContext", "applicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption(new MainCommandLineSupport.ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based spring ApplicationContext", "fileApplicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setFileApplicationContextUri(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
        System.exit(main.getExitCode());
    }

    public static Main getInstance() {
        return instance;
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public AbstractApplicationContext getParentApplicationContext() {
        if (this.parentApplicationContext == null && this.parentApplicationContextUri != null) {
            this.parentApplicationContext = new ClassPathXmlApplicationContext(this.parentApplicationContextUri);
            this.parentApplicationContext.start();
        }
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(AbstractApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public String getParentApplicationContextUri() {
        return this.parentApplicationContextUri;
    }

    public void setParentApplicationContextUri(String parentApplicationContextUri) {
        this.parentApplicationContextUri = parentApplicationContextUri;
    }

    public boolean isAllowMultipleCamelContexts() {
        return this.allowMultipleCamelContexts;
    }

    public void setAllowMultipleCamelContexts(boolean allowMultipleCamelContexts) {
        this.allowMultipleCamelContexts = allowMultipleCamelContexts;
    }

    @Override
    protected CamelContext createCamelContext() {
        Map<String, SpringCamelContext> camels = this.applicationContext.getBeansOfType(SpringCamelContext.class);
        if (camels.size() > 1) {
            if (this.isAllowMultipleCamelContexts()) {
                return camels.values().iterator().next();
            }
            throw new IllegalArgumentException("Multiple CamelContext detected. Set allowMultipleCamelContexts=true to allow multiple CamelContexts");
        }
        if (camels.size() == 1) {
            return camels.values().iterator().next();
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        try {
            super.doStart();
            if (this.applicationContext == null) {
                this.applicationContext = this.createDefaultApplicationContext();
            }
            if (this.additionalApplicationContext == null) {
                this.additionalApplicationContext = this.createAdditionalLocationsFromClasspath();
                if (this.additionalApplicationContext != null) {
                    LOG.debug("Starting Additional ApplicationContext: {}", (Object)this.additionalApplicationContext.getId());
                    this.additionalApplicationContext.start();
                }
            }
            LOG.debug("Starting Spring ApplicationContext: {}", (Object)this.applicationContext.getId());
            this.applicationContext.start();
            this.initCamelContext();
        }
        catch (Exception e) {
            VetoCamelContextStartException veto = ObjectHelper.getException(VetoCamelContextStartException.class, e);
            if (veto != null) {
                this.completed();
            }
            throw e;
        }
    }

    @Override
    protected void doStop() throws Exception {
        try {
            if (this.additionalApplicationContext != null) {
                LOG.debug("Stopping Additional ApplicationContext: {}", (Object)this.additionalApplicationContext.getId());
                this.additionalApplicationContext.stop();
            }
            if (this.applicationContext != null) {
                LOG.debug("Stopping Spring ApplicationContext: {}", (Object)this.applicationContext.getId());
                this.applicationContext.stop();
            }
            IOHelper.close((Closeable)this.additionalApplicationContext);
            IOHelper.close((Closeable)this.applicationContext);
        }
        finally {
            super.doStop();
        }
    }

    @Override
    protected ProducerTemplate findOrCreateCamelTemplate() {
        String[] names = this.getApplicationContext().getBeanNamesForType(ProducerTemplate.class);
        if (names != null && names.length > 0) {
            return this.getApplicationContext().getBean(names[0], ProducerTemplate.class);
        }
        if (this.getCamelContext() == null) {
            throw new IllegalArgumentException("No CamelContext are available so cannot create a ProducerTemplate!");
        }
        return this.getCamelContext().createProducerTemplate();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        if (this.getFileApplicationContextUri() != null) {
            String[] args = this.getFileApplicationContextUri().split(";");
            if (parentContext != null) {
                return new FileSystemXmlApplicationContext(args, parentContext);
            }
            return new FileSystemXmlApplicationContext(args);
        }
        String[] args = this.getApplicationContextUri().split(";");
        if (parentContext != null) {
            return new ClassPathXmlApplicationContext(args, parentContext);
        }
        if (this.mainConfigurationProperties.getRoutesBuilderClasses() != null) {
            String[] classes;
            AnnotationConfigApplicationContext ac = new AnnotationConfigApplicationContext();
            ac.register(SpringCamelContext.class);
            LinkedHashSet<String> packages = new LinkedHashSet<String>();
            for (String clazz : classes = this.mainConfigurationProperties.getRoutesBuilderClasses().split(",")) {
                if (!clazz.contains(".")) continue;
                String packageName = clazz.substring(0, clazz.lastIndexOf(46));
                packages.add(packageName);
            }
            LOG.info("Using Spring annotation scanning in packages: {}", packages);
            ac.scan(packages.toArray(new String[0]));
            ac.refresh();
            return ac;
        }
        return new ClassPathXmlApplicationContext(args);
    }

    protected AbstractApplicationContext createAdditionalLocationsFromClasspath() throws IOException {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        this.findLocations(locations, Main.class.getClassLoader());
        if (!locations.isEmpty()) {
            LOG.info("Found locations for additional Spring XML files: {}", locations);
            String[] locs = locations.toArray(new String[0]);
            return new ClassPathXmlApplicationContext(locs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findLocations(Set<String> locations, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(LOCATION_PROPERTIES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            BufferedReader reader = IOHelper.buffered(new InputStreamReader(url.openStream(), UTF8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                    locations.add(line);
                }
            }
            finally {
                IOHelper.close((Closeable)reader, null, LOG);
            }
        }
    }

    static {
        UTF8 = StandardCharsets.UTF_8;
    }
}

