/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.scheduling.TaskScheduler;

public class DirectRabbitListenerContainerFactory
extends AbstractRabbitListenerContainerFactory<DirectMessageListenerContainer> {
    private TaskScheduler taskScheduler;
    private Long monitorInterval;
    private Integer consumersPerQueue = 1;
    private Integer messagesPerAck;
    private Long ackTimeout;

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setMonitorInterval(long monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void setConsumersPerQueue(Integer consumersPerQueue) {
        this.consumersPerQueue = consumersPerQueue;
    }

    public void setMessagesPerAck(Integer messagesPerAck) {
        this.messagesPerAck = messagesPerAck;
    }

    public void setAckTimeout(Long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    @Override
    protected DirectMessageListenerContainer createContainerInstance() {
        return new DirectMessageListenerContainer();
    }

    @Override
    protected void initializeContainer(DirectMessageListenerContainer instance, RabbitListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfNotNull(this.taskScheduler, instance::setTaskScheduler).acceptIfNotNull(this.monitorInterval, instance::setMonitorInterval).acceptIfNotNull(this.messagesPerAck, instance::setMessagesPerAck).acceptIfNotNull(this.ackTimeout, instance::setAckTimeout);
        if (endpoint != null && endpoint.getConcurrency() != null) {
            try {
                instance.setConsumersPerQueue(Integer.parseInt(endpoint.getConcurrency()));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Failed to parse concurrency: " + e.getMessage(), e);
            }
        } else {
            javaUtils.acceptIfNotNull(this.consumersPerQueue, instance::setConsumersPerQueue);
        }
    }
}

