/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.FactoryFinder;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;

public interface NodeLocator<T> {
    public static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(NodeLocator.class));

    @Nullable
    default public ConnectionFactory locate(String[] adminUris, Map<String, String> nodeToAddress, String vhost, String username, String password, String queue, FactoryFinder factoryFunction) {
        T client = this.createClient(username, password);
        for (int i2 = 0; i2 < adminUris.length; ++i2) {
            Object adminUri = adminUris[i2];
            if (!((String)adminUri).endsWith("/api/")) {
                adminUri = (String)adminUri + "/api/";
            }
            try {
                String uri = new URI((String)adminUri).resolve("/api/queues/").toString();
                Map<String, Object> queueInfo = this.restCall(client, uri, vhost, queue);
                if (queueInfo != null) {
                    String node = (String)queueInfo.get("node");
                    if (node == null) continue;
                    String nodeUri = nodeToAddress.get(node);
                    if (nodeUri != null) {
                        this.close(client);
                        return factoryFunction.locate(queue, node, nodeUri);
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("No match for node: " + node);
                    continue;
                }
                throw new AmqpException("Admin returned null QueueInfo");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to determine queue location for: " + queue + " at: " + (String)adminUri + ": " + e.getMessage());
            }
        }
        LOGGER.warn("Failed to determine queue location for: " + queue + ", using default connection factory");
        this.close(client);
        return null;
    }

    public T createClient(String var1, String var2);

    default public void close(T client) {
    }

    @Nullable
    public Map<String, Object> restCall(T var1, String var2, String var3, String var4) throws URISyntaxException;
}

