/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.BrokerEvent;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BrokerEventListener
implements MessageListener,
ApplicationEventPublisherAware,
ConnectionListener,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(BrokerEventListener.class);
    private final Lock lock = new ReentrantLock();
    private final AbstractMessageListenerContainer container;
    private final String[] eventKeys;
    private final RabbitAdmin admin;
    private final Queue eventQueue = new AnonymousQueue(new Base64UrlNamingStrategy("spring.events."));
    private final boolean ownContainer;
    private int phase;
    private boolean autoStartup = true;
    private boolean running;
    private boolean stopInvoked;
    private Exception bindingsFailedException;
    private ApplicationEventPublisher applicationEventPublisher;

    public BrokerEventListener(ConnectionFactory connectionFactory, String ... eventKeys) {
        this((AbstractMessageListenerContainer)new DirectMessageListenerContainer(connectionFactory), true, eventKeys);
    }

    public BrokerEventListener(AbstractMessageListenerContainer container, String ... eventKeys) {
        this(container, false, eventKeys);
    }

    private BrokerEventListener(AbstractMessageListenerContainer container, boolean ownContainer, String ... eventKeys) {
        Assert.notNull((Object)container, "listener container cannot be null");
        Assert.isTrue(!ObjectUtils.isEmpty(eventKeys), "At least one event key is required");
        this.container = container;
        this.container.setQueues(this.eventQueue);
        this.container.setMessageListener(this);
        this.eventKeys = Arrays.copyOf(eventKeys, eventKeys.length);
        this.container.getConnectionFactory().addConnectionListener(this);
        this.admin = new RabbitAdmin(this.container.getConnectionFactory());
        this.ownContainer = ownContainer;
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Nullable
    public Exception getBindingsFailedException() {
        return this.bindingsFailedException;
    }

    @Override
    public void start() {
        this.lock.lock();
        try {
            if (!this.running) {
                if (this.stopInvoked) {
                    this.stopInvoked = false;
                    this.onCreate(null);
                }
                if (this.ownContainer) {
                    this.container.start();
                }
                this.running = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.running) {
                if (this.ownContainer) {
                    this.container.stop();
                }
                this.running = false;
                this.stopInvoked = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public void onMessage(Message message) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(new BrokerEvent((Object)this, message.getMessageProperties()));
        } else if (logger.isWarnEnabled()) {
            logger.warn("No event publisher available for " + message + "; if the BrokerEventListener is not defined as a bean, you must provide an ApplicationEventPublisher");
        }
    }

    @Override
    public void onCreate(@Nullable Connection connection) {
        this.bindingsFailedException = null;
        TopicExchange exchange = new TopicExchange("amq.rabbitmq.event");
        try {
            this.admin.declareQueue(this.eventQueue);
            Arrays.stream(this.eventKeys).forEach(k -> {
                Binding binding = BindingBuilder.bind(this.eventQueue).to(exchange).with((String)k);
                this.admin.declareBinding(binding);
            });
        }
        catch (Exception e) {
            logger.error("failed to declare event queue/bindings - is the plugin enabled?", e);
            this.bindingsFailedException = e;
        }
    }
}

