/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.springframework.amqp.rabbit.listener.adapter.ContinuationHandlerMethodArgumentResolver;
import org.springframework.amqp.rabbit.listener.adapter.KotlinAwareInvocableHandlerMethod;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class AmqpMessageHandlerMethodFactory
extends DefaultMessageHandlerMethodFactory {
    private final HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private MessageConverter messageConverter;
    private Validator validator;

    @Override
    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messageConverter = messageConverter;
    }

    @Override
    public void setValidator(Validator validator) {
        super.setValidator(validator);
        this.validator = validator;
    }

    @Override
    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        List<HandlerMethodArgumentResolver> resolvers = super.initArgumentResolvers();
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.add(resolvers.size() - 1, new ContinuationHandlerMethodArgumentResolver());
        }
        resolvers.add(resolvers.size() - 1, new OptionalEmptyAwarePayloadArgumentResolver(this.messageConverter, this.validator));
        this.argumentResolvers.addResolvers(resolvers);
        return resolvers;
    }

    @Override
    public InvocableHandlerMethod createInvocableHandlerMethod(Object bean2, Method method) {
        KotlinAwareInvocableHandlerMethod handlerMethod = new KotlinAwareInvocableHandlerMethod(bean2, method);
        handlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
        return handlerMethod;
    }

    private static class OptionalEmptyAwarePayloadArgumentResolver
    extends PayloadMethodArgumentResolver {
        OptionalEmptyAwarePayloadArgumentResolver(MessageConverter messageConverter, @Nullable Validator validator) {
            super(messageConverter, validator);
        }

        @Override
        public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
            Object resolved;
            try {
                resolved = super.resolveArgument(parameter, message);
            }
            catch (MethodArgumentNotValidException ex) {
                String defaultMessage;
                List<ObjectError> allErrors;
                BindingResult bindingResult;
                Type type = parameter.getGenericParameterType();
                if (this.isOptional(message, type) && (bindingResult = ex.getBindingResult()) != null && (allErrors = bindingResult.getAllErrors()).size() == 1 && "Payload value must not be empty".equals(defaultMessage = allErrors.get(0).getDefaultMessage())) {
                    return Optional.empty();
                }
                throw ex;
            }
            if (resolved instanceof List) {
                List list = (List)resolved;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!list.get(i2).equals(Optional.empty())) continue;
                    list.set(i2, null);
                }
            }
            return resolved;
        }

        private boolean isOptional(Message<?> message, Type type) {
            ParameterizedType pType;
            return (Optional.class.equals((Object)type) || type instanceof ParameterizedType && Optional.class.equals((Object)(pType = (ParameterizedType)type).getRawType())) && message.getPayload().equals(Optional.empty());
        }

        @Override
        protected boolean isEmptyPayload(Object payload) {
            return payload == null || payload.equals(Optional.empty());
        }
    }
}

