/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.ImmediateRequeueAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;

public class ImmediateRequeueMessageRecoverer
implements MessageRecoverer {
    protected Log logger = LogFactory.getLog(ImmediateRequeueMessageRecoverer.class);

    @Override
    public void recover(Message message, Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Retries exhausted for message " + message + "; requeuing...", cause);
        }
        throw new ImmediateRequeueAmqpException(cause);
    }
}

