/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservationConvention;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageReceiverContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitListenerObservation implements ObservationDocumentation
{
    LISTENER_OBSERVATION{

        @Override
        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitListenerObservationConvention.class;
        }

        @Override
        public String getPrefix() {
            return "spring.rabbit.listener";
        }

        @Override
        public KeyName[] getLowCardinalityKeyNames() {
            return ListenerLowCardinalityTags.values();
        }
    };


    public static class DefaultRabbitListenerObservationConvention
    implements RabbitListenerObservationConvention {
        public static final DefaultRabbitListenerObservationConvention INSTANCE = new DefaultRabbitListenerObservationConvention();

        @Override
        public KeyValues getLowCardinalityKeyValues(RabbitMessageReceiverContext context) {
            return KeyValues.of(ListenerLowCardinalityTags.LISTENER_ID.asString(), context.getListenerId());
        }

        @Override
        public String getContextualName(RabbitMessageReceiverContext context) {
            return context.getSource() + " receive";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerLowCardinalityTags implements KeyName
    {
        LISTENER_ID{

            @Override
            public String asString() {
                return "spring.rabbit.listener.id";
            }
        };

    }
}

