/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageSenderContext;
import org.springframework.amqp.rabbit.support.micrometer.RabbitTemplateObservationConvention;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitTemplateObservation implements ObservationDocumentation
{
    TEMPLATE_OBSERVATION{

        @Override
        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitTemplateObservationConvention.class;
        }

        @Override
        public String getPrefix() {
            return "spring.rabbit.template";
        }

        @Override
        public KeyName[] getLowCardinalityKeyNames() {
            return TemplateLowCardinalityTags.values();
        }
    };


    public static class DefaultRabbitTemplateObservationConvention
    implements RabbitTemplateObservationConvention {
        public static final DefaultRabbitTemplateObservationConvention INSTANCE = new DefaultRabbitTemplateObservationConvention();

        @Override
        public KeyValues getLowCardinalityKeyValues(RabbitMessageSenderContext context) {
            return KeyValues.of(TemplateLowCardinalityTags.BEAN_NAME.asString(), context.getBeanName());
        }

        @Override
        public String getContextualName(RabbitMessageSenderContext context) {
            return context.getDestination() + " send";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLowCardinalityTags implements KeyName
    {
        BEAN_NAME{

            @Override
            public String asString() {
                return "spring.rabbit.template.name";
            }
        };

    }
}

