/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.concurrent.Callable;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.SimpleResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConnectionFactoryContextWrapper {
    private final ConnectionFactory connectionFactory;

    public ConnectionFactoryContextWrapper(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "'connectionFactory' must not be null");
        this.connectionFactory = connectionFactory;
    }

    public <T> T call(Callable<T> callable) {
        return this.call(null, callable);
    }

    public <T> T call(@Nullable String contextName, Callable<T> callable) {
        try {
            this.bind(contextName);
            T t = callable.call();
            return t;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.unbind(contextName);
        }
    }

    public void run(Runnable runnable) {
        this.run(null, runnable);
    }

    public void run(@Nullable String contextName, Runnable runnable) {
        try {
            this.bind(contextName);
            runnable.run();
        }
        finally {
            this.unbind(contextName);
        }
    }

    private void bind(@Nullable String contextName) {
        if (StringUtils.hasText(contextName)) {
            SimpleResourceHolder.bind(this.connectionFactory, contextName);
        }
    }

    private void unbind(@Nullable String contextName) {
        if (StringUtils.hasText(contextName)) {
            SimpleResourceHolder.unbind(this.connectionFactory);
        }
    }
}

