/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.util.Assert;

public class RejectAndDontRequeueRecoverer
implements MessageRecoverer {
    private final Supplier<String> messageSupplier;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public RejectAndDontRequeueRecoverer() {
        this(() -> "Retry Policy Exhausted");
    }

    public RejectAndDontRequeueRecoverer(String message) {
        this(() -> message);
    }

    public RejectAndDontRequeueRecoverer(Supplier<String> messageSupplier) {
        Assert.notNull(messageSupplier, "'messageSupplier' cannot be null");
        this.messageSupplier = messageSupplier;
    }

    @Override
    public void recover(Message message, Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Retries exhausted for message " + message, cause);
        }
        throw new ListenerExecutionFailedException(this.messageSupplier.get(), (Throwable)new AmqpRejectAndDontRequeueException(cause), message);
    }
}

