/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.AbstractHeaderMapper;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class SimpleAmqpHeaderMapper
extends AbstractHeaderMapper<MessageProperties>
implements AmqpHeaderMapper {
    @Override
    public void fromHeaders(MessageHeaders headers, MessageProperties amqpMessageProperties) {
        String replyToStack;
        JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_appId", String.class), amqpMessageProperties::setAppId).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_clusterId", String.class), amqpMessageProperties::setClusterId).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_contentEncoding", String.class), amqpMessageProperties::setContentEncoding).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_contentLength", Long.class), amqpMessageProperties::setContentLength).acceptIfHasText(this.extractContentTypeAsString(headers), amqpMessageProperties::setContentType);
        Object correlationId = headers.get("amqp_correlationId");
        if (correlationId instanceof String) {
            amqpMessageProperties.setCorrelationId((String)correlationId);
        }
        javaUtils.acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_delay", Long.class), amqpMessageProperties::setDelayLong).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_deliveryMode", MessageDeliveryMode.class), amqpMessageProperties::setDeliveryMode).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_deliveryTag", Long.class), amqpMessageProperties::setDeliveryTag).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_expiration", String.class), amqpMessageProperties::setExpiration).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_messageCount", Integer.class), amqpMessageProperties::setMessageCount).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_messageId", String.class), amqpMessageProperties::setMessageId).acceptIfNotNull(this.getHeaderIfAvailable(headers, "priority", Integer.class), amqpMessageProperties::setPriority).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_receivedExchange", String.class), amqpMessageProperties::setReceivedExchange).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_receivedRoutingKey", String.class), amqpMessageProperties::setReceivedRoutingKey).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_redelivered", Boolean.class), amqpMessageProperties::setRedelivered).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_replyTo", String.class), amqpMessageProperties::setReplyTo).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_timestamp", Date.class), amqpMessageProperties::setTimestamp).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_type", String.class), amqpMessageProperties::setType).acceptIfHasText(this.getHeaderIfAvailable(headers, "amqp_userId", String.class), amqpMessageProperties::setUserId);
        String replyCorrelation = this.getHeaderIfAvailable(headers, "amqp_springReplyCorrelation", String.class);
        if (StringUtils.hasLength(replyCorrelation)) {
            amqpMessageProperties.setHeader("spring_reply_correlation", replyCorrelation);
        }
        if (StringUtils.hasLength(replyToStack = this.getHeaderIfAvailable(headers, "amqp_springReplyToStack", String.class))) {
            amqpMessageProperties.setHeader("spring_reply_to", replyToStack);
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            Object value;
            String headerName = entry.getKey();
            if (!StringUtils.hasText(headerName) || headerName.startsWith("amqp_") || (value = entry.getValue()) == null) continue;
            String propertyName = this.fromHeaderName(headerName);
            if (amqpMessageProperties.getHeaders().containsKey(headerName)) continue;
            amqpMessageProperties.setHeader(propertyName, value);
        }
    }

    @Override
    public MessageHeaders toHeaders(MessageProperties amqpMessageProperties) {
        HashMap<String, Object> headers;
        block3: {
            headers = new HashMap<String, Object>();
            try {
                BiConsumer<String, Object> putObject = headers::put;
                BiConsumer<String, String> putString = headers::put;
                JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfNotNull("amqp_appId", amqpMessageProperties.getAppId(), putObject).acceptIfNotNull("amqp_clusterId", amqpMessageProperties.getClusterId(), putObject).acceptIfNotNull("amqp_contentEncoding", amqpMessageProperties.getContentEncoding(), putObject);
                long contentLength = amqpMessageProperties.getContentLength();
                javaUtils.acceptIfCondition(contentLength > 0L, "amqp_contentLength", contentLength, putObject).acceptIfHasText("contentType", amqpMessageProperties.getContentType(), putString).acceptIfHasText("amqp_correlationId", amqpMessageProperties.getCorrelationId(), putString).acceptIfNotNull("amqp_receivedDeliveryMode", amqpMessageProperties.getReceivedDeliveryMode(), putObject);
                long deliveryTag = amqpMessageProperties.getDeliveryTag();
                javaUtils.acceptIfCondition(deliveryTag > 0L, "amqp_deliveryTag", deliveryTag, putObject).acceptIfHasText("amqp_expiration", amqpMessageProperties.getExpiration(), putString).acceptIfNotNull("amqp_messageCount", amqpMessageProperties.getMessageCount(), putObject).acceptIfNotNull("amqp_messageId", amqpMessageProperties.getMessageId(), putObject);
                Integer priority = amqpMessageProperties.getPriority();
                javaUtils.acceptIfCondition(priority != null && priority > 0, "priority", priority, putObject).acceptIfNotNull("amqp_receivedDelay", amqpMessageProperties.getReceivedDelayLong(), putObject).acceptIfHasText("amqp_receivedExchange", amqpMessageProperties.getReceivedExchange(), putString).acceptIfHasText("amqp_receivedRoutingKey", amqpMessageProperties.getReceivedRoutingKey(), putString).acceptIfNotNull("amqp_redelivered", amqpMessageProperties.isRedelivered(), putObject).acceptIfNotNull("amqp_replyTo", amqpMessageProperties.getReplyTo(), putObject).acceptIfNotNull("amqp_timestamp", amqpMessageProperties.getTimestamp(), putObject).acceptIfHasText("amqp_type", amqpMessageProperties.getType(), putString).acceptIfHasText("amqp_receivedUserId", amqpMessageProperties.getReceivedUserId(), putString).acceptIfHasText("amqp_consumerTag", amqpMessageProperties.getConsumerTag(), putString).acceptIfHasText("amqp_consumerQueue", amqpMessageProperties.getConsumerQueue(), putString);
                headers.put("amqp_lastInBatch", amqpMessageProperties.isLastInBatch());
                for (Map.Entry<String, Object> entry : amqpMessageProperties.getHeaders().entrySet()) {
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn("error occurred while mapping from AMQP properties to MessageHeaders", e);
            }
        }
        return new MessageHeaders(headers);
    }

    private String extractContentTypeAsString(Map<String, Object> headers) {
        String contentTypeStringValue = null;
        Object contentType = this.getHeaderIfAvailable(headers, "contentType", Object.class);
        if (contentType != null) {
            if (contentType instanceof MimeType) {
                contentTypeStringValue = contentType.toString();
            } else if (contentType instanceof String) {
                contentTypeStringValue = (String)contentType;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("skipping header 'contentType' since it is not of expected type [" + contentType.getClass().getName() + "]");
            }
        }
        return contentTypeStringValue;
    }
}

