/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Objects;
import java.util.function.IntFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class OffsetScrollPosition
implements ScrollPosition {
    private static final OffsetScrollPosition INITIAL = new OffsetScrollPosition(-1L);
    private final long offset;

    private OffsetScrollPosition(long offset) {
        this.offset = offset;
    }

    static OffsetScrollPosition initial() {
        return INITIAL;
    }

    static OffsetScrollPosition of(long offset) {
        Assert.isTrue(offset >= 0L, "Offset must not be negative");
        return new OffsetScrollPosition(offset);
    }

    public static IntFunction<OffsetScrollPosition> positionFunction(long startOffset) {
        Assert.isTrue(startOffset >= 0L, "Start offset must not be negative");
        return startOffset == 0L ? OffsetPositionFunction.ZERO : new OffsetPositionFunction(startOffset);
    }

    public IntFunction<OffsetScrollPosition> positionFunction() {
        return OffsetScrollPosition.positionFunction(this.offset + 1L);
    }

    public long getOffset() {
        Assert.state(this.offset >= 0L, "Initial state does not have an offset. Make sure to check #isInitial()");
        return this.offset;
    }

    public OffsetScrollPosition advanceBy(long delta) {
        long value = this.isInitial() ? delta : this.offset + delta;
        return new OffsetScrollPosition(value < 0L ? 0L : value);
    }

    @Override
    public boolean isInitial() {
        return this.offset == -1L;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetScrollPosition)) {
            return false;
        }
        OffsetScrollPosition that = (OffsetScrollPosition)o;
        return Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }

    public String toString() {
        return String.format("OffsetScrollPosition [%s]", this.offset);
    }

    private record OffsetPositionFunction(long startOffset) implements IntFunction<OffsetScrollPosition>
    {
        static final OffsetPositionFunction ZERO = new OffsetPositionFunction(0L);

        @Override
        public OffsetScrollPosition apply(int offset) {
            if (offset < 0) {
                throw new IndexOutOfBoundsException(offset);
            }
            return OffsetScrollPosition.of(this.startOffset + (long)offset);
        }
    }
}

