/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

class GeneratingIdAccessor
implements IdentifierAccessor {
    private final PersistentPropertyAccessor<?> accessor;
    private final PersistentProperty<?> identifierProperty;
    private final IdentifierGenerator generator;

    GeneratingIdAccessor(PersistentPropertyAccessor<?> accessor, PersistentProperty<?> identifierProperty, IdentifierGenerator generator) {
        Assert.notNull(accessor, "PersistentPropertyAccessor must not be null");
        Assert.notNull(identifierProperty, "Identifier property must not be null");
        Assert.notNull((Object)generator, "IdentifierGenerator must not be null");
        this.accessor = accessor;
        this.identifierProperty = identifierProperty;
        this.generator = generator;
    }

    @Override
    public Object getIdentifier() {
        return this.accessor.getProperty(this.identifierProperty);
    }

    Object getOrGenerateIdentifier() {
        Object existingIdentifier = this.getIdentifier();
        if (existingIdentifier != null) {
            return existingIdentifier;
        }
        Object generatedIdentifier = this.generator.generateIdentifierOfType(this.identifierProperty.getTypeInformation());
        this.accessor.setProperty(this.identifierProperty, generatedIdentifier);
        return generatedIdentifier;
    }
}

