/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.keyvalue.core.SimplePropertyPathAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.Lazy;
import org.springframework.util.comparator.NullSafeComparator;

public class PropertyPathComparator<T>
implements Comparator<T> {
    private final String path;
    private boolean asc = true;
    private boolean nullsFirst = true;
    private final Map<Class<?>, PropertyPath> pathCache = new HashMap(2);
    private Lazy<Comparator<Object>> comparator = Lazy.of(() -> new NullSafeComparator(Comparator.naturalOrder(), this.nullsFirst));

    public PropertyPathComparator(String path) {
        this.path = path;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return this.nullsFirst ? 1 : -1;
        }
        if (o2 == null) {
            return this.nullsFirst ? 1 : -1;
        }
        PropertyPath propertyPath = this.pathCache.computeIfAbsent(o1.getClass(), it -> PropertyPath.from(this.path, it));
        Object value1 = new SimplePropertyPathAccessor(o1).getValue(propertyPath);
        Object value2 = new SimplePropertyPathAccessor(o2).getValue(propertyPath);
        return this.comparator.get().compare(value1, value2) * (this.asc ? 1 : -1);
    }

    public PropertyPathComparator<T> asc() {
        this.asc = true;
        return this;
    }

    public PropertyPathComparator<T> desc() {
        this.asc = false;
        return this;
    }

    public PropertyPathComparator<T> nullsFirst() {
        this.nullsFirst = true;
        return this;
    }

    public PropertyPathComparator<T> nullsLast() {
        this.nullsFirst = false;
        return this;
    }
}

