/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.util.RedisAssertions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RedisClusterNode
extends RedisNode {
    @Nullable
    private LinkState linkState;
    private Set<Flag> flags = Collections.emptySet();
    private final SlotRange slotRange;

    public static RedisClusterNodeBuilder newRedisClusterNode() {
        return new RedisClusterNodeBuilder();
    }

    protected RedisClusterNode() {
        this.slotRange = SlotRange.empty();
    }

    public RedisClusterNode(String host, int port) {
        this(host, port, SlotRange.empty());
    }

    public RedisClusterNode(String id) {
        this(SlotRange.empty());
        this.id = RedisAssertions.requireNonNull(id, "Id must not be null", new Object[0]);
    }

    public RedisClusterNode(SlotRange slotRange) {
        this.slotRange = RedisAssertions.requireNonNull(slotRange, "SlotRange must not be null", new Object[0]);
    }

    public RedisClusterNode(String host, int port, SlotRange slotRange) {
        super(host, port);
        this.slotRange = RedisAssertions.requireNonNull(slotRange, "SlotRange must not be null", new Object[0]);
    }

    public SlotRange getSlotRange() {
        return this.slotRange;
    }

    public boolean servesSlot(int slot) {
        return this.getSlotRange().contains(slot);
    }

    @Nullable
    public LinkState getLinkState() {
        return this.linkState;
    }

    public boolean isConnected() {
        return LinkState.CONNECTED.equals((Object)this.getLinkState());
    }

    public Set<Flag> getFlags() {
        return this.flags != null ? this.flags : Collections.emptySet();
    }

    public boolean isMarkedAsFail() {
        return CollectionUtils.containsAny(this.getFlags(), Arrays.asList(Flag.FAIL, Flag.PFAIL));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class RedisClusterNodeBuilder
    extends RedisNode.RedisNodeBuilder {
        @Nullable
        Set<Flag> flags;
        @Nullable
        LinkState linkState;
        SlotRange slotRange = SlotRange.empty();

        @Override
        public RedisClusterNodeBuilder listeningAt(String host, int port) {
            super.listeningAt(host, port);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder withId(String id) {
            super.withId(id);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder promotedAs(RedisNode.NodeType nodeType) {
            super.promotedAs(nodeType);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder replicaOf(String masterId) {
            super.replicaOf(masterId);
            return this;
        }

        public RedisClusterNodeBuilder withFlags(Set<Flag> flags) {
            this.flags = flags;
            return this;
        }

        public RedisClusterNodeBuilder serving(SlotRange range) {
            this.slotRange = range;
            return this;
        }

        public RedisClusterNodeBuilder linkState(LinkState linkState) {
            this.linkState = linkState;
            return this;
        }

        @Override
        public RedisClusterNode build() {
            RedisNode base = super.build();
            RedisClusterNode node = base.host != null ? new RedisClusterNode(base.getHost(), base.getPort(), this.slotRange) : new RedisClusterNode(this.slotRange);
            node.id = base.id;
            node.type = base.type;
            node.masterId = base.masterId;
            node.name = base.name;
            node.flags = this.flags;
            node.linkState = this.linkState;
            return node;
        }
    }

    public static class SlotRange {
        private final BitSet range;

        public static SlotRange empty() {
            return new SlotRange(Collections.emptySet());
        }

        public SlotRange(Integer lowerBound, Integer upperBound) {
            Assert.notNull((Object)lowerBound, "LowerBound must not be null");
            Assert.notNull((Object)upperBound, "UpperBound must not be null");
            this.range = new BitSet(upperBound + 1);
            for (int bitindex = lowerBound.intValue(); bitindex <= upperBound; ++bitindex) {
                this.range.set(bitindex);
            }
        }

        public SlotRange(Collection<Integer> range) {
            if (CollectionUtils.isEmpty(range)) {
                this.range = new BitSet(0);
            } else {
                this.range = new BitSet(16384);
                for (Integer bitindex : range) {
                    this.range.set(bitindex);
                }
            }
        }

        public SlotRange(BitSet range) {
            this.range = (BitSet)range.clone();
        }

        public boolean contains(int slot) {
            return this.range.get(slot);
        }

        public Set<Integer> getSlots() {
            if (this.range.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>(Math.max(2 * this.range.cardinality(), 11));
            for (int bitindex = 0; bitindex < this.range.length(); ++bitindex) {
                if (!this.range.get(bitindex)) continue;
                slots.add(bitindex);
            }
            return Collections.unmodifiableSet(slots);
        }

        public int[] getSlotsArray() {
            if (this.range.isEmpty()) {
                return new int[0];
            }
            int[] slots = new int[this.range.cardinality()];
            int arrayIndex = 0;
            for (int slot = 0; slot < 16384; ++slot) {
                if (!this.range.get(slot)) continue;
                slots[arrayIndex++] = slot;
            }
            return slots;
        }

        public String toString() {
            return Arrays.toString(this.getSlotsArray());
        }
    }

    public static enum LinkState {
        CONNECTED,
        DISCONNECTED;

    }

    public static enum Flag {
        MYSELF("myself"),
        MASTER("master"),
        REPLICA("slave"),
        FAIL("fail"),
        PFAIL("fail?"),
        HANDSHAKE("handshake"),
        NOADDR("noaddr"),
        NOFLAGS("noflags");

        private String raw;

        private Flag(String raw) {
            this.raw = raw;
        }

        public String getRaw() {
            return this.raw;
        }
    }
}

