/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisSentinelConfiguration
implements RedisConfiguration,
RedisConfiguration.SentinelConfiguration {
    private static final String REDIS_SENTINEL_MASTER_CONFIG_PROPERTY = "spring.redis.sentinel.master";
    private static final String REDIS_SENTINEL_NODES_CONFIG_PROPERTY = "spring.redis.sentinel.nodes";
    private static final String REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY = "spring.redis.sentinel.username";
    private static final String REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.password";
    private static final String REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.username";
    private static final String REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.password";
    private static final String REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.database";
    private int database;
    @Nullable
    private NamedNode master;
    private RedisPassword dataNodePassword = RedisPassword.none();
    private RedisPassword sentinelPassword = RedisPassword.none();
    private final Set<RedisNode> sentinels;
    @Nullable
    private String dataNodeUsername = null;
    @Nullable
    private String sentinelUsername = null;

    public RedisSentinelConfiguration() {
        this(new MapPropertySource("RedisSentinelConfiguration", Collections.emptyMap()));
    }

    public RedisSentinelConfiguration(String master, Set<String> sentinelHostAndPorts) {
        this(new MapPropertySource("RedisSentinelConfiguration", RedisSentinelConfiguration.asMap(master, sentinelHostAndPorts)));
    }

    @Deprecated(since="3.3")
    public RedisSentinelConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, "PropertySource must not be null");
        this.sentinels = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY)) {
            String sentinelMaster = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY));
            this.setMaster(sentinelMaster);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY)) {
            String sentinelNodes = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY));
            this.appendSentinels(StringUtils.commaDelimitedListToSet(sentinelNodes));
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY)) {
            String sentinelPassword = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY));
            this.setSentinelPassword(sentinelPassword);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY)) {
            String sentinelUsername = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY));
            this.setSentinelUsername(sentinelUsername);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY)) {
            String dataNodeUsername = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY));
            this.setUsername(dataNodeUsername);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY)) {
            String dataNodePassword = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY));
            this.setPassword(dataNodePassword);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY)) {
            int database;
            String databaseSource = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY));
            try {
                database = Integer.parseInt(databaseSource);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Invalid DB index '%s'; integer required", databaseSource));
            }
            this.setDatabase(database);
        }
    }

    public static RedisSentinelConfiguration of(PropertySource<?> propertySource) {
        return new RedisSentinelConfiguration(propertySource);
    }

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, "Cannot set sentinels to null");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    @Override
    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, "Sentinel must not be null");
        this.sentinels.add(sentinel);
    }

    @Override
    public void setMaster(NamedNode master) {
        Assert.notNull((Object)master, "Sentinel master node must not be null");
        this.master = master;
    }

    @Override
    @Nullable
    public NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }

    private void appendSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(RedisNode.fromString(hostAndPort));
        }
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%d'; non-negative index required", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.dataNodeUsername = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.dataNodeUsername;
    }

    @Override
    public RedisPassword getPassword() {
        return this.dataNodePassword;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null");
        this.dataNodePassword = password;
    }

    @Override
    @Nullable
    public String getSentinelUsername() {
        return this.sentinelUsername;
    }

    @Override
    public void setSentinelUsername(@Nullable String sentinelUsername) {
        this.sentinelUsername = sentinelUsername;
    }

    @Override
    public void setSentinelPassword(RedisPassword sentinelPassword) {
        Assert.notNull((Object)sentinelPassword, "SentinelPassword must not be null");
        this.sentinelPassword = sentinelPassword;
    }

    @Override
    public RedisPassword getSentinelPassword() {
        return this.sentinelPassword;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RedisSentinelConfiguration)) {
            return false;
        }
        RedisSentinelConfiguration that = (RedisSentinelConfiguration)obj;
        return this.database == that.database && ObjectUtils.nullSafeEquals(this.master, that.master) && ObjectUtils.nullSafeEquals(this.sentinels, that.sentinels) && ObjectUtils.nullSafeEquals(this.dataNodeUsername, that.dataNodeUsername) && ObjectUtils.nullSafeEquals(this.dataNodePassword, that.dataNodePassword) && ObjectUtils.nullSafeEquals(this.sentinelUsername, that.sentinelUsername) && ObjectUtils.nullSafeEquals(this.sentinelPassword, that.sentinelPassword);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.master);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinels);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.dataNodeUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.dataNodePassword);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinelUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinelPassword);
        return result;
    }

    private static Map<String, Object> asMap(String master, Set<String> sentinelHostAndPorts) {
        Assert.hasText(master, "Master address must not be null or empty");
        Assert.notNull(sentinelHostAndPorts, "SentinelHostAndPorts must not be null");
        Assert.noNullElements(sentinelHostAndPorts, "ClusterHostAndPorts must not contain null elements");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY, master);
        map.put(REDIS_SENTINEL_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(sentinelHostAndPorts));
        return map;
    }
}

