/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.net.UnknownHostException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ClusterRedirectException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.TooManyClusterRedirectionsException;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisRedirectionException;

public class JedisExceptionConverter
implements Converter<Exception, DataAccessException> {
    static final JedisExceptionConverter INSTANCE = new JedisExceptionConverter();

    @Override
    public DataAccessException convert(Exception ex) {
        if (ex instanceof DataAccessException) {
            DataAccessException dae = (DataAccessException)ex;
            return dae;
        }
        if (ex instanceof JedisClusterOperationException && "No more cluster attempts left".equals(ex.getMessage())) {
            return new TooManyClusterRedirectionsException(ex.getMessage(), ex);
        }
        if (ex instanceof JedisRedirectionException) {
            JedisRedirectionException rex = (JedisRedirectionException)ex;
            return new ClusterRedirectException(rex.getSlot(), rex.getTargetNode().getHost(), rex.getTargetNode().getPort(), ex);
        }
        if (ex instanceof JedisConnectionException) {
            return new RedisConnectionFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof JedisException || ex instanceof UnsupportedOperationException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof UnknownHostException) {
            return new RedisConnectionFailureException("Unknown host " + ex.getMessage(), ex);
        }
        if (ex instanceof IOException) {
            return new RedisConnectionFailureException("Could not connect to Redis server", ex);
        }
        return null;
    }
}

