/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.args.SaveMode;

class JedisServerCommands
implements RedisServerCommands {
    private final JedisConnection connection;

    JedisServerCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        this.connection.invoke().just(Jedis::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.invokeStatus().just(Jedis::bgsave);
    }

    @Override
    public Long lastSave() {
        return this.connection.invoke().just(Jedis::lastsave);
    }

    @Override
    public void save() {
        this.connection.invokeStatus().just(Jedis::save);
    }

    @Override
    public Long dbSize() {
        return this.connection.invoke().just(Jedis::dbSize);
    }

    @Override
    public void flushDb() {
        this.connection.invokeStatus().just(Jedis::flushDB);
    }

    @Override
    public void flushDb(RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(j -> j.flushDB(JedisConverters.toFlushMode(option)));
    }

    @Override
    public void flushAll() {
        this.connection.invokeStatus().just(Jedis::flushAll);
    }

    @Override
    public void flushAll(RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(j -> j.flushAll(JedisConverters.toFlushMode(option)));
    }

    @Override
    public Properties info() {
        return this.connection.invoke().from(Jedis::info).get(Converters::toProperties);
    }

    @Override
    public Properties info(String section) {
        Assert.notNull((Object)section, "Section must not be null");
        return this.connection.invoke().from(j -> j.info(section)).get(Converters::toProperties);
    }

    @Override
    public void shutdown() {
        this.connection.invokeStatus().just(jedis -> {
            jedis.shutdown();
            return null;
        });
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        SaveMode saveMode = option == RedisServerCommands.ShutdownOption.NOSAVE ? SaveMode.NOSAVE : SaveMode.SAVE;
        this.connection.getJedis().shutdown(saveMode);
    }

    @Override
    public Properties getConfig(String pattern) {
        Assert.notNull((Object)pattern, "Pattern must not be null");
        return this.connection.invoke().from(j -> j.configGet(pattern)).get(Converters::toProperties);
    }

    @Override
    public void setConfig(String param, String value) {
        Assert.notNull((Object)param, "Parameter must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        this.connection.invokeStatus().just(j -> j.configSet(param, value));
    }

    @Override
    public void resetConfigStats() {
        this.connection.invokeStatus().just(Jedis::configResetStat);
    }

    @Override
    public void rewriteConfig() {
        this.connection.invokeStatus().just(Jedis::configRewrite);
    }

    @Override
    public Long time(TimeUnit timeUnit) {
        Assert.notNull((Object)timeUnit, "TimeUnit must not be null");
        return this.connection.invoke().from(Jedis::time).get(source -> JedisConverters.toTime(source, timeUnit));
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText(host, "Host for 'CLIENT KILL' must not be 'null' or 'empty'");
        this.connection.invokeStatus().just(it -> it.clientKill(String.format("%s:%s", host, port)));
    }

    @Override
    public void setClientName(byte[] name) {
        Assert.notNull((Object)name, "Name must not be null");
        this.connection.invokeStatus().just(it -> it.clientSetname(name));
    }

    @Override
    public String getClientName() {
        return this.connection.invokeStatus().just(Jedis::clientGetname);
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        return this.connection.invokeStatus().from(Jedis::clientList).get(JedisConverters::toListOfRedisClientInformation);
    }

    @Override
    public void replicaOf(String host, int port) {
        Assert.hasText(host, "Host must not be null for 'REPLICAOF' command");
        this.connection.invokeStatus().just(it -> it.replicaof(host, port));
    }

    @Override
    public void replicaOfNoOne() {
        this.connection.invokeStatus().just(Jedis::replicaofNoOne);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)target, "Target node must not be null");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        this.connection.invokeStatus().just(j -> j.migrate(target.getHost(), (int)target.getPort(), key, dbIndex, timeoutToUse));
    }
}

