/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.StreamBinaryCommands;
import redis.clients.jedis.commands.StreamPipelineBinaryCommands;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;

class JedisStreamCommands
implements RedisStreamCommands {
    private final JedisConnection connection;

    JedisStreamCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.hasText(group, "Group name must not be null or empty");
        Assert.notNull((Object)recordIds, "recordIds must not be null");
        return this.connection.invoke().just(Jedis::xack, StreamPipelineBinaryCommands::xack, key, JedisConverters.toBytes(group), StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, "Record must not be null");
        Assert.notNull(record.getStream(), "Stream must not be null");
        XAddParams params = StreamConverters.toXAddParams(record.getId(), options);
        return this.connection.invoke().from(StreamBinaryCommands::xadd, StreamPipelineBinaryCommands::xadd, (byte[])record.getStream(), (Map)record.getValue(), params).get(it -> RecordId.of(JedisConverters.toString(it)));
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)group, "Group must not be null");
        Assert.notNull((Object)newOwner, "NewOwner must not be null");
        XClaimParams params = StreamConverters.toXClaimParams(options);
        return this.connection.invoke().fromMany(Jedis::xclaimJustId, StreamPipelineBinaryCommands::xclaimJustId, key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), options.getMinIdleTime().toMillis(), params, StreamConverters.entryIdsToBytes(options.getIds())).toList(it -> RecordId.of(JedisConverters.toString(it)));
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)group, "Group must not be null");
        Assert.notNull((Object)newOwner, "NewOwner must not be null");
        XClaimParams params = StreamConverters.toXClaimParams(options);
        return this.connection.invoke().from(Jedis::xclaim, StreamPipelineBinaryCommands::xclaim, key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), options.getMinIdleTime().toMillis(), params, StreamConverters.entryIdsToBytes(options.getIds())).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)recordIds, "recordIds must not be null");
        return this.connection.invoke().just(Jedis::xdel, StreamPipelineBinaryCommands::xdel, key, StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.hasText(groupName, "Group name must not be null or empty");
        Assert.notNull((Object)readOffset, "ReadOffset must not be null");
        return this.connection.invoke().just(Jedis::xgroupCreate, StreamPipelineBinaryCommands::xgroupCreate, key, JedisConverters.toBytes(groupName), JedisConverters.toBytes(readOffset.getOffset()), mkStream);
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)consumer, "Consumer must not be null");
        return this.connection.invoke().from(Jedis::xgroupDelConsumer, StreamPipelineBinaryCommands::xgroupDelConsumer, key, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName())).get(r -> r > 0L);
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.hasText(groupName, "Group name must not be null or empty");
        return this.connection.invoke().from(Jedis::xgroupDestroy, StreamPipelineBinaryCommands::xgroupDestroy, key, JedisConverters.toBytes(groupName)).get(r -> r > 0L);
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::xinfoStream, StreamPipelineBinaryCommands::xinfoStream, key).get(it -> {
            StreamInfo streamInfo = BuilderFactory.STREAM_INFO.build(it);
            return StreamInfo.XInfoStream.fromList(StreamConverters.mapToList(streamInfo.getStreamInfo()));
        });
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::xinfoGroups, StreamPipelineBinaryCommands::xinfoGroups, key).get(it -> {
            List<StreamGroupInfo> streamGroupInfos = BuilderFactory.STREAM_GROUP_INFO_LIST.build(it);
            ArrayList<Object> sources = new ArrayList<Object>();
            streamGroupInfos.forEach(streamGroupInfo -> sources.add(StreamConverters.mapToList(streamGroupInfo.getGroupInfo())));
            return StreamInfo.XInfoGroups.fromList(sources);
        });
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.hasText(groupName, "Group name must not be null or empty");
        return this.connection.invoke().from(Jedis::xinfoConsumers, StreamPipelineBinaryCommands::xinfoConsumers, key, JedisConverters.toBytes(groupName)).get(it -> {
            List<StreamConsumersInfo> streamConsumersInfos = BuilderFactory.STREAM_CONSUMERS_INFO_LIST.build(it);
            ArrayList<Object> sources = new ArrayList<Object>();
            streamConsumersInfos.forEach(streamConsumersInfo -> sources.add(StreamConverters.mapToList(streamConsumersInfo.getConsumerInfo())));
            return StreamInfo.XInfoConsumers.fromList(groupName, sources);
        });
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::xlen, StreamPipelineBinaryCommands::xlen, key);
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::xpending, StreamPipelineBinaryCommands::xpending, key, JedisConverters.toBytes(groupName)).get(it -> StreamConverters.toPendingMessagesSummary(groupName, it));
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)groupName, "GroupName must not be null");
        Range<?> range = options.getRange();
        XPendingParams xPendingParams = StreamConverters.toXPendingParams(options);
        return this.connection.invoke().from(Jedis::xpending, StreamPipelineBinaryCommands::xpending, key, JedisConverters.toBytes(groupName), xPendingParams).get(r -> StreamConverters.toPendingMessages(groupName, range, BuilderFactory.STREAM_PENDING_ENTRY_LIST.build(r)));
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, Range<String> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null");
        Assert.notNull((Object)limit, "Limit must not be null");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return this.connection.invoke().from(Jedis::xrange, StreamPipelineBinaryCommands::xrange, key, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), count).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null");
        Assert.notNull(streams, "StreamOffsets must not be null");
        XReadParams params = StreamConverters.toXReadParams(readOptions);
        return this.connection.invoke().from(Jedis::xread, StreamPipelineBinaryCommands::xread, params, StreamConverters.toStreamOffsets(streams)).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, "Consumer must not be null");
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null");
        Assert.notNull(streams, "StreamOffsets must not be null");
        XReadGroupParams params = StreamConverters.toXReadGroupParams(readOptions);
        return this.connection.invoke().from(Jedis::xreadGroup, StreamPipelineBinaryCommands::xreadGroup, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName()), params, StreamConverters.toStreamOffsets(streams)).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null");
        Assert.notNull((Object)limit, "Limit must not be null");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return this.connection.invoke().from(Jedis::xrevrange, StreamPipelineBinaryCommands::xrevrange, key, JedisConverters.toBytes(StreamConverters.getUpperValue(range)), JedisConverters.toBytes(StreamConverters.getLowerValue(range)), count).get(it -> StreamConverters.convertToByteRecord(key, it));
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::xtrim, StreamPipelineBinaryCommands::xtrim, key, count, approximateTrimming);
    }
}

