/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.SortedSetPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.KeyValue;

class JedisZSetCommands
implements RedisZSetCommands {
    private final JedisConnection connection;

    JedisZSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().from(Jedis::zadd, SortedSetPipelineBinaryCommands::zadd, key, score, value, JedisConverters.toZAddParams(args)).get(Converters::toBoolean);
    }

    @Override
    public Long zAdd(byte[] key, Set<Tuple> tuples, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(tuples, "Tuples must not be null");
        Long count = this.connection.invoke().just(Jedis::zadd, SortedSetPipelineBinaryCommands::zadd, key, JedisConverters.toTupleMap(tuples), JedisConverters.toZAddParams(args));
        return count != null ? count : 0L;
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Values must not be null");
        Assert.noNullElements((Object[])values, "Values must not contain null elements");
        return this.connection.invoke().just(Jedis::zrem, SortedSetPipelineBinaryCommands::zrem, key, values);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::zincrby, SortedSetPipelineBinaryCommands::zincrby, key, increment, value);
    }

    @Override
    public byte[] zRandMember(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::zrandmember, SortedSetPipelineBinaryCommands::zrandmember, key);
    }

    @Override
    public List<byte[]> zRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrandmember, SortedSetPipelineBinaryCommands::zrandmember, key, count).toList();
    }

    @Override
    public Tuple zRandMemberWithScore(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::zrandmemberWithScores, SortedSetPipelineBinaryCommands::zrandmemberWithScores, key, 1L).get(it -> {
            if (it.isEmpty()) {
                return null;
            }
            return JedisConverters.toTuple((redis.clients.jedis.resps.Tuple)it.iterator().next());
        });
    }

    @Override
    public List<Tuple> zRandMemberWithScore(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrandmemberWithScores, SortedSetPipelineBinaryCommands::zrandmemberWithScores, key, count).toList(JedisConverters::toTuple);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::zrank, SortedSetPipelineBinaryCommands::zrank, key, value);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::zrevrank, SortedSetPipelineBinaryCommands::zrevrank, key, value);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrange, SortedSetPipelineBinaryCommands::zrange, key, start, end).toSet();
    }

    @Override
    public Set<Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrangeWithScores, SortedSetPipelineBinaryCommands::zrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range<? extends Number> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZRANGEBYSCOREWITHSCORES must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrangeByScoreWithScores, key, min, max, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrangeByScoreWithScores, key, min, max).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrevrange, SortedSetPipelineBinaryCommands::zrevrange, key, start, end).toSet();
    }

    @Override
    public Set<Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrevrangeWithScores, SortedSetPipelineBinaryCommands::zrevrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, Range<? extends Number> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZREVRANGEBYSCORE must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrevrangeByScore, SortedSetPipelineBinaryCommands::zrevrangeByScore, key, max, min, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrevrangeByScore, SortedSetPipelineBinaryCommands::zrevrangeByScore, key, max, min).toSet();
    }

    @Override
    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range<? extends Number> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZREVRANGEBYSCOREWITHSCORES must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrevrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrevrangeByScoreWithScores, key, max, min, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(Jedis::zrevrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrevrangeByScoreWithScores, key, max, min).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::zcount, SortedSetPipelineBinaryCommands::zcount, key, min, max);
    }

    @Override
    public Long zCount(byte[] key, Range<? extends Number> range) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(Jedis::zcount, SortedSetPipelineBinaryCommands::zcount, key, min, max);
    }

    @Override
    public Long zLexCount(byte[] key, Range<byte[]> range) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getUpperBound(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(Jedis::zlexcount, SortedSetPipelineBinaryCommands::zlexcount, key, min, max);
    }

    @Override
    @Nullable
    public Tuple zPopMin(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::zpopmin, SortedSetPipelineBinaryCommands::zpopmin, key).get(JedisConverters::toTuple);
    }

    @Override
    @Nullable
    public Set<Tuple> zPopMin(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zpopmin, SortedSetPipelineBinaryCommands::zpopmin, key, Math.toIntExact(count)).toSet(JedisConverters::toTuple);
    }

    @Override
    @Nullable
    public Tuple bZPopMin(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)unit, "TimeUnit must not be null");
        return this.connection.invoke().from((rec$, x$0, xva$1) -> rec$.bzpopmin((double)x$0, new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.bzpopmin((double)x$0, new byte[][]{xva$1}), JedisConverters.toSeconds(timeout, unit), key).get(JedisZSetCommands::toTuple);
    }

    @Override
    @Nullable
    public Tuple zPopMax(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::zpopmax, SortedSetPipelineBinaryCommands::zpopmax, key).get(JedisConverters::toTuple);
    }

    @Override
    @Nullable
    public Set<Tuple> zPopMax(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zpopmax, SortedSetPipelineBinaryCommands::zpopmax, key, Math.toIntExact(count)).toSet(JedisConverters::toTuple);
    }

    @Override
    @Nullable
    public Tuple bZPopMax(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)unit, "TimeUnit must not be null");
        return this.connection.invoke().from((rec$, x$0, xva$1) -> rec$.bzpopmax((double)x$0, new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.bzpopmax((double)x$0, new byte[][]{xva$1}), JedisConverters.toSeconds(timeout, unit), key).get(JedisZSetCommands::toTuple);
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::zcard, SortedSetPipelineBinaryCommands::zcard, key);
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::zscore, SortedSetPipelineBinaryCommands::zscore, key, value);
    }

    @Override
    public List<Double> zMScore(byte[] key, byte[][] values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Value must not be null");
        return this.connection.invoke().just(Jedis::zmscore, SortedSetPipelineBinaryCommands::zmscore, key, values);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::zremrangeByRank, SortedSetPipelineBinaryCommands::zremrangeByRank, key, start, end);
    }

    @Override
    public Long zRemRangeByLex(byte[] key, Range<byte[]> range) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null for ZREMRANGEBYLEX");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getUpperBound(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(Jedis::zremrangeByLex, SortedSetPipelineBinaryCommands::zremrangeByLex, key, min, max);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, Range<? extends Number> range) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZREMRANGEBYSCORE must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(Jedis::zremrangeByScore, SortedSetPipelineBinaryCommands::zremrangeByScore, key, min, max);
    }

    @Override
    public Set<byte[]> zDiff(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zdiff, SortedSetPipelineBinaryCommands::zdiff, sets).toSet();
    }

    @Override
    public Set<Tuple> zDiffWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zdiffWithScores, SortedSetPipelineBinaryCommands::zdiffWithScores, sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zDiffStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)sets, "Source sets must not be null");
        return this.connection.invoke().just(Jedis::zdiffStore, SortedSetPipelineBinaryCommands::zdiffStore, destKey, sets);
    }

    @Override
    public Set<byte[]> zInter(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zinter, SortedSetPipelineBinaryCommands::zinter, new ZParams(), sets).toSet();
    }

    @Override
    public Set<Tuple> zInterWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zinterWithScores, SortedSetPipelineBinaryCommands::zinterWithScores, new ZParams(), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<Tuple> zInterWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)", weights.size(), sets.length));
        return this.connection.invoke().fromMany(Jedis::zinterWithScores, SortedSetPipelineBinaryCommands::zinterWithScores, JedisZSetCommands.toZParams(aggregate, weights), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zInterStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)sets, "Source sets must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)", weights.size(), sets.length));
        ZParams zparams = JedisZSetCommands.toZParams(aggregate, weights);
        return this.connection.invoke().just(Jedis::zinterstore, SortedSetPipelineBinaryCommands::zinterstore, destKey, zparams, sets);
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)sets, "Source sets must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        return this.connection.invoke().just(Jedis::zinterstore, SortedSetPipelineBinaryCommands::zinterstore, destKey, sets);
    }

    @Override
    public Set<byte[]> zUnion(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zunion, SortedSetPipelineBinaryCommands::zunion, new ZParams(), sets).toSet();
    }

    @Override
    public Set<Tuple> zUnionWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zunionWithScores, SortedSetPipelineBinaryCommands::zunionWithScores, new ZParams(), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<Tuple> zUnionWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, "Sets must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)", weights.size(), sets.length));
        return this.connection.invoke().fromMany(Jedis::zunionWithScores, SortedSetPipelineBinaryCommands::zunionWithScores, JedisZSetCommands.toZParams(aggregate, weights), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zUnionStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)sets, "Source sets must not be null");
        Assert.notNull((Object)weights, "Weights must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)", weights.size(), sets.length));
        ZParams zparams = JedisZSetCommands.toZParams(aggregate, weights);
        return this.connection.invoke().just(Jedis::zunionstore, SortedSetPipelineBinaryCommands::zunionstore, destKey, zparams, sets);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)sets, "Source sets must not be null");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements");
        return this.connection.invoke().just(Jedis::zunionstore, SortedSetPipelineBinaryCommands::zunionstore, destKey, sets);
    }

    @Override
    public Cursor<Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, Cursor.CursorId.initial(), options);
    }

    public Cursor<Tuple> zScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
        Assert.notNull((Object)key, "Key must not be null");
        return new KeyBoundCursor<Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<Tuple> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (JedisZSetCommands.this.isQueueing() || JedisZSetCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'ZSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult<redis.clients.jedis.resps.Tuple> result = JedisZSetCommands.this.connection.getJedis().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Tuple>(Cursor.CursorId.of(result.getCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, JedisConverters.toBytes(min), JedisConverters.toBytes(max)).toSet();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset and count must be less than Integer.MAX_VALUE for zRangeByScore in Jedis");
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), (int)offset, (int)count).toSet();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, Range<? extends Number> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZRANGEBYSCORE must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, min, max, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, min, max).toSet();
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, Range<byte[]> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZRANGEBYLEX must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getUpperBound(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByLex, SortedSetPipelineBinaryCommands::zrangeByLex, key, min, max, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByLex, SortedSetPipelineBinaryCommands::zrangeByLex, key, min, max).toSet();
    }

    @Override
    public Set<byte[]> zRevRangeByLex(byte[] key, Range<byte[]> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range for ZREVRANGEBYLEX must not be null");
        Assert.notNull((Object)limit, "Limit must not be null Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getUpperBound(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().from(Jedis::zrevrangeByLex, SortedSetPipelineBinaryCommands::zrevrangeByLex, key, max, min, limit.getOffset(), limit.getCount()).get(LinkedHashSet::new);
        }
        return this.connection.invoke().from(Jedis::zrevrangeByLex, SortedSetPipelineBinaryCommands::zrevrangeByLex, key, max, min).get(LinkedHashSet::new);
    }

    @Override
    public Long zRangeStoreByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, false);
    }

    @Override
    public Long zRangeStoreRevByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull(range, "Range must not be null");
        Assert.notNull((Object)limit, "Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getUpperBound(), JedisConverters.PLUS_BYTES);
        ZRangeParams zRangeParams = JedisZSetCommands.toZRangeParams(Protocol.Keyword.BYLEX, min, max, limit, rev);
        return this.connection.invoke().just(Jedis::zrangestore, SortedSetPipelineBinaryCommands::zrangestore, dstKey, srcKey, zRangeParams);
    }

    @Override
    public Long zRangeStoreByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, false);
    }

    @Override
    public Long zRangeStoreRevByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull(range, "Range must not be null");
        Assert.notNull((Object)limit, "Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        ZRangeParams zRangeParams = JedisZSetCommands.toZRangeParams(Protocol.Keyword.BYSCORE, min, max, limit, rev);
        return this.connection.invoke().just(Jedis::zrangestore, SortedSetPipelineBinaryCommands::zrangestore, dstKey, srcKey, zRangeParams);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private static ZParams toZParams(Aggregate aggregate, Weights weights) {
        return new ZParams().weights(weights.toArray()).aggregate(ZParams.Aggregate.valueOf(aggregate.name()));
    }

    static ZRangeParams toZRangeParams(Protocol.Keyword by, byte[] min, byte[] max, Limit limit, boolean rev) {
        ZRangeParams zRangeParams = rev ? new ZRangeParams(by, max, min).rev() : new ZRangeParams(by, min, max);
        if (limit.isLimited()) {
            zRangeParams = zRangeParams.limit(limit.getOffset(), limit.getCount());
        }
        return zRangeParams;
    }

    @Nullable
    private static Tuple toTuple(@Nullable KeyValue<?, redis.clients.jedis.resps.Tuple> keyValue) {
        return keyValue != null ? JedisConverters.toTuple((redis.clients.jedis.resps.Tuple)keyValue.getValue()) : null;
    }
}

