/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisException;
import io.netty.channel.ChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;

public class LettuceExceptionConverter
implements Converter<Exception, DataAccessException> {
    static final LettuceExceptionConverter INSTANCE = new LettuceExceptionConverter();

    @Override
    public DataAccessException convert(Exception ex) {
        if (ex instanceof ExecutionException || ex instanceof RedisCommandExecutionException) {
            Throwable throwable;
            if (ex.getCause() != ex && (throwable = ex.getCause()) instanceof Exception) {
                Exception cause = (Exception)throwable;
                return this.convert(cause);
            }
            return new RedisSystemException("Error in execution", ex);
        }
        if (ex instanceof DataAccessException) {
            DataAccessException dae = (DataAccessException)ex;
            return dae;
        }
        if (ex instanceof RedisCommandInterruptedException) {
            return new RedisSystemException("Redis command interrupted", ex);
        }
        if (ex instanceof ChannelException || ex instanceof RedisConnectionException) {
            return new RedisConnectionFailureException("Redis connection failed", ex);
        }
        if (ex instanceof TimeoutException || ex instanceof RedisCommandTimeoutException) {
            return new QueryTimeoutException("Redis command timed out", ex);
        }
        if (ex instanceof RedisException) {
            return new RedisSystemException("Redis exception", ex);
        }
        return null;
    }
}

