/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.CopyArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SortArgs;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceScanCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceKeyCommands
implements RedisKeyCommands {
    private final LettuceConnection connection;

    LettuceKeyCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean copy(byte[] sourceKey, byte[] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, "source key must not be null");
        Assert.notNull((Object)targetKey, "target key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::copy, sourceKey, targetKey, CopyArgs.Builder.replace((boolean)replace));
    }

    @Override
    public Boolean exists(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from((rec$, xva$0) -> rec$.exists((Object[])new byte[][]{xva$0}), key).get(LettuceConverters.longToBooleanConverter());
    }

    @Override
    @Nullable
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::exists, keys);
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::del, keys);
    }

    @Override
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::unlink, keys);
    }

    @Override
    public DataType type(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(RedisKeyAsyncCommands::type, key).get(LettuceConverters.stringToDataType());
    }

    @Override
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::touch, keys);
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, "Pattern must not be null");
        return this.connection.invoke().fromMany(RedisKeyAsyncCommands::keys, pattern).toSet();
    }

    public Cursor<byte[]> scan() {
        return this.scan(ScanOptions.NONE);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.doScan(options != null ? options : ScanOptions.NONE);
    }

    private Cursor<byte[]> doScan(ScanOptions options) {
        return new LettuceScanCursor<byte[]>(options){

            @Override
            protected LettuceScanCursor.LettuceScanIteration<byte[]> doScan(ScanCursor cursor, ScanOptions options) {
                if (LettuceKeyCommands.this.connection.isQueueing() || LettuceKeyCommands.this.connection.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'SCAN' cannot be called in pipeline / transaction mode");
                }
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                KeyScanCursor keyScanCursor = (KeyScanCursor)LettuceKeyCommands.this.connection.invoke().just(RedisKeyAsyncCommands::scan, cursor, scanArgs);
                List keys = keyScanCursor.getKeys();
                return new LettuceScanCursor.LettuceScanIteration<byte[]>((ScanCursor)keyScanCursor, keys);
            }

            @Override
            protected void doClose() {
                LettuceKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        return (byte[])this.connection.invoke().just(RedisKeyAsyncCommands::randomkey);
    }

    @Override
    public void rename(byte[] oldKey, byte[] newKey) {
        Assert.notNull((Object)oldKey, "Old key must not be null");
        Assert.notNull((Object)newKey, "New key must not be null");
        this.connection.invokeStatus().just(RedisKeyAsyncCommands::rename, oldKey, newKey);
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, "Source key must not be null");
        Assert.notNull((Object)targetKey, "Target key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::renamenx, sourceKey, targetKey);
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::expire, key, seconds);
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::pexpire, key, millis);
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::expireat, key, unixTime);
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::pexpireat, key, unixTimeInMillis);
    }

    @Override
    public Boolean persist(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::persist, key);
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Boolean)this.connection.invoke().just(RedisKeyAsyncCommands::move, key, dbIndex);
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::ttl, key);
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(RedisKeyAsyncCommands::ttl, key).get(Converters.secondsToTimeUnit(timeUnit));
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::pttl, key);
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(RedisKeyAsyncCommands::pttl, key).get(Converters.millisecondsToTimeUnit(timeUnit));
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Assert.notNull((Object)key, "Key must not be null");
        SortArgs args = LettuceConverters.toSortArgs(params);
        return (List)this.connection.invoke().just(RedisKeyAsyncCommands::sort, key, args);
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        Assert.notNull((Object)key, "Key must not be null");
        SortArgs args = LettuceConverters.toSortArgs(params);
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::sortStore, key, args, sortKey);
    }

    @Override
    public byte[] dump(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return (byte[])this.connection.invoke().just(RedisKeyAsyncCommands::dump, key);
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)serializedValue, "Serialized value must not be null");
        RestoreArgs restoreArgs = RestoreArgs.Builder.ttl((long)ttlInMillis).replace(replace);
        this.connection.invokeStatus().just(RedisKeyAsyncCommands::restore, key, serializedValue, restoreArgs);
    }

    @Override
    @Nullable
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(RedisKeyAsyncCommands::objectEncoding, key).orElse(ValueEncoding::of, ValueEncoding.RedisValueEncoding.VACANT);
    }

    @Override
    @Nullable
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(RedisKeyAsyncCommands::objectIdletime, key).get(Converters::secondsToDuration);
    }

    @Override
    @Nullable
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return (Long)this.connection.invoke().just(RedisKeyAsyncCommands::objectRefcount, key);
    }
}

