/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.lettuce.core.sentinel.api.sync.RedisSentinelCommands;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.connection.lettuce.LettuceFutureUtils;
import org.springframework.util.Assert;

public class LettuceSentinelConnection
implements RedisSentinelConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(LettuceExceptionConverter.INSTANCE);
    private final LettuceConnectionProvider provider;
    private StatefulRedisSentinelConnection<String, String> connection;

    public LettuceSentinelConnection(RedisNode sentinel) {
        this(sentinel.getHost(), sentinel.getPort());
    }

    public LettuceSentinelConnection(String host, int port) {
        Assert.notNull((Object)host, "Cannot create LettuceSentinelConnection using 'null' as host.");
        this.provider = new DedicatedClientConnectionProvider(host, port);
        this.init();
    }

    public LettuceSentinelConnection(String host, int port, ClientResources clientResources) {
        Assert.notNull((Object)clientResources, "Cannot create LettuceSentinelConnection using 'null' as ClientResources.");
        Assert.notNull((Object)host, "Cannot create LettuceSentinelConnection using 'null' as host.");
        this.provider = new DedicatedClientConnectionProvider(host, port, clientResources);
        this.init();
    }

    public LettuceSentinelConnection(final RedisClient redisClient) {
        Assert.notNull((Object)redisClient, "Cannot create LettuceSentinelConnection using 'null' as client.");
        this.provider = new LettuceConnectionProvider(){

            @Override
            public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> t) {
                return (T)((StatefulConnection)t.cast(redisClient.connectSentinel()));
            }

            public <T extends StatefulConnection<?, ?>> CompletableFuture<T> getConnectionAsync(Class<T> t) {
                return CompletableFuture.completedFuture((StatefulConnection)t.cast(LettuceSentinelConnection.this.connection));
            }
        };
        this.init();
    }

    protected LettuceSentinelConnection(final StatefulRedisSentinelConnection<String, String> connection) {
        Assert.notNull(connection, "Cannot create LettuceSentinelConnection using 'null' as connection.");
        this.provider = new LettuceConnectionProvider(){

            @Override
            public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> t) {
                return (T)((StatefulConnection)t.cast(connection));
            }

            public <T extends StatefulConnection<?, ?>> CompletableFuture<T> getConnectionAsync(Class<T> t) {
                return CompletableFuture.completedFuture((StatefulConnection)t.cast(connection));
            }
        };
        this.init();
    }

    public LettuceSentinelConnection(LettuceConnectionProvider connectionProvider) {
        Assert.notNull((Object)connectionProvider, "LettuceConnectionProvider must not be null");
        this.provider = connectionProvider;
        this.init();
    }

    @Override
    public void failover(NamedNode master) {
        Assert.notNull((Object)master, "Redis node master must not be 'null' for failover.");
        Assert.hasText(master.getName(), "Redis master name must not be 'null' or empty for failover.");
        this.getSentinelCommands().failover((Object)master.getName());
    }

    public List<RedisServer> masters() {
        try {
            return LettuceConverters.toListOfRedisServer(this.getSentinelCommands().masters());
        }
        catch (Exception ex) {
            throw EXCEPTION_TRANSLATION.translate(ex);
        }
    }

    public List<RedisServer> replicas(NamedNode master) {
        Assert.notNull((Object)master, "Master node cannot be 'null' when loading replicas.");
        return this.slaves(master.getName());
    }

    public List<RedisServer> slaves(String masterName) {
        Assert.hasText(masterName, "Name of redis master cannot be 'null' or empty when loading replicas.");
        try {
            return LettuceConverters.toListOfRedisServer(this.getSentinelCommands().slaves((Object)masterName));
        }
        catch (Exception ex) {
            throw EXCEPTION_TRANSLATION.translate(ex);
        }
    }

    @Override
    public void remove(NamedNode master) {
        Assert.notNull((Object)master, "Master node cannot be 'null' when trying to remove.");
        this.remove(master.getName());
    }

    public void remove(String masterName) {
        Assert.hasText(masterName, "Name of redis master cannot be 'null' or empty when trying to remove.");
        this.getSentinelCommands().remove((Object)masterName);
    }

    @Override
    public void monitor(RedisServer server) {
        Assert.notNull((Object)server, "Cannot monitor 'null' server.");
        Assert.hasText(server.getName(), "Name of server to monitor must not be 'null' or empty");
        Assert.hasText(server.getHost(), "Host must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getPort(), "Port must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getQuorum(), "Quorum must not be 'null' for server to monitor.");
        this.getSentinelCommands().monitor((Object)server.getName(), server.getHost(), server.getPort().intValue(), server.getQuorum().intValue());
    }

    @Override
    public void close() throws IOException {
        this.provider.release((StatefulConnection<?, ?>)this.connection);
    }

    private void init() {
        if (this.connection == null) {
            this.connection = this.provider.getConnection(StatefulRedisSentinelConnection.class);
        }
    }

    private RedisSentinelCommands<String, String> getSentinelCommands() {
        return this.connection.sync();
    }

    @Override
    public boolean isOpen() {
        return this.connection != null && this.connection.isOpen();
    }

    private static class DedicatedClientConnectionProvider
    implements LettuceConnectionProvider {
        private final RedisClient redisClient;
        private final RedisURI uri;

        DedicatedClientConnectionProvider(String host, int port) {
            Assert.notNull((Object)host, "Cannot create LettuceSentinelConnection using 'null' as host.");
            this.uri = RedisURI.Builder.redis((String)host, (int)port).build();
            this.redisClient = RedisClient.create((RedisURI)this.uri);
        }

        DedicatedClientConnectionProvider(String host, int port, ClientResources clientResources) {
            Assert.notNull((Object)clientResources, "Cannot create LettuceSentinelConnection using 'null' as ClientResources.");
            Assert.notNull((Object)host, "Cannot create LettuceSentinelConnection using 'null' as host.");
            this.uri = RedisURI.Builder.redis((String)host, (int)port).build();
            this.redisClient = RedisClient.create((ClientResources)clientResources, (RedisURI)this.uri);
        }

        public <T extends StatefulConnection<?, ?>> CompletableFuture<T> getConnectionAsync(Class<T> connectionType) {
            return this.redisClient.connectSentinelAsync((RedisCodec)StringCodec.UTF8, this.uri).thenApply(connectionType::cast);
        }

        @Override
        public void release(StatefulConnection<?, ?> connection) {
            connection.close();
            this.redisClient.shutdown();
        }

        @Override
        public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
            return ((CompletableFuture)connection.closeAsync().exceptionally(LettuceFutureUtils.ignoreErrors())).thenCompose(it -> this.redisClient.shutdownAsync());
        }
    }
}

