/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.stream.PendingMessage;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class PendingMessages
implements Streamable<PendingMessage> {
    private final String groupName;
    private final Range<?> range;
    private final List<PendingMessage> pendingMessages;

    public PendingMessages(String groupName, List<PendingMessage> pendingMessages) {
        this(groupName, Range.unbounded(), pendingMessages);
    }

    public PendingMessages(String groupName, Range<?> range, List<PendingMessage> pendingMessages) {
        Assert.notNull(range, "Range must not be null");
        Assert.notNull(pendingMessages, "Pending Messages must not be null");
        this.groupName = groupName;
        this.range = range;
        this.pendingMessages = pendingMessages;
    }

    public PendingMessages withinRange(Range<?> range) {
        return new PendingMessages(this.groupName, range, this.pendingMessages);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Range<?> getRange() {
        return this.range;
    }

    @Override
    public boolean isEmpty() {
        return this.pendingMessages.isEmpty();
    }

    public int size() {
        return this.pendingMessages.size();
    }

    public PendingMessage get(int index) {
        return this.pendingMessages.get(index);
    }

    @Override
    public Iterator<PendingMessage> iterator() {
        return this.pendingMessages.iterator();
    }

    public String toString() {
        return "PendingMessages{groupName='" + this.groupName + "', range=" + this.range + ", pendingMessages=" + this.pendingMessages + "}";
    }
}

