/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.zset;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Weights {
    private final List<Double> weights;

    private Weights(List<Double> weights) {
        this.weights = weights;
    }

    public static Weights of(int ... weights) {
        Assert.notNull((Object)weights, "Weights must not be null");
        return new Weights(Arrays.stream(weights).mapToDouble(value -> value).boxed().collect(Collectors.toList()));
    }

    public static Weights of(double ... weights) {
        Assert.notNull((Object)weights, "Weights must not be null");
        return new Weights(DoubleStream.of(weights).boxed().collect(Collectors.toList()));
    }

    public static Weights fromSetCount(int count) {
        Assert.isTrue(count >= 0, "Count of input sorted sets must be greater or equal to zero");
        return new Weights(IntStream.range(0, count).mapToDouble(value -> 1.0).boxed().collect(Collectors.toList()));
    }

    public Weights multiply(int multiplier) {
        return this.apply(it -> it * (double)multiplier);
    }

    public Weights multiply(double multiplier) {
        return this.apply(it -> it * multiplier);
    }

    public Weights apply(Function<Double, Double> operator) {
        return new Weights(this.weights.stream().map(operator).collect(Collectors.toList()));
    }

    public double getWeight(int index) {
        return this.weights.get(index);
    }

    public int size() {
        return this.weights.size();
    }

    public double[] toArray() {
        return this.weights.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public List<Double> toList() {
        return Collections.unmodifiableList(this.weights);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Weights)) {
            return false;
        }
        Weights that = (Weights)o;
        return ObjectUtils.nullSafeEquals(this.weights, that.weights);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.weights);
    }
}

