/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.ReactiveListOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveListOperations<K, V>
implements ReactiveListOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveListOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Flux<V> range(K key, long start, long end) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(connection -> connection.lRange(this.rawKey(key), start, end).map(this::readRequiredValue));
    }

    @Override
    public Mono<Boolean> trim(K key, long start, long end) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lTrim(this.rawKey(key), start, end));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lLen(this.rawKey(key)));
    }

    @Override
    public Mono<Long> leftPush(K key, V value) {
        return this.leftPushAll(key, value);
    }

    @Override
    @SafeVarargs
    public final Mono<Long> leftPushAll(K key, V ... values) {
        Assert.notEmpty((Object[])values, "Values must not be null or empty");
        return this.leftPushAll(key, (Collection<V>)Arrays.asList(values));
    }

    @Override
    public Mono<Long> leftPushAll(K key, Collection<V> values) {
        Assert.notNull(key, "Key must not be null");
        Assert.notEmpty(values, "Values must not be null or empty");
        return this.createMono(listCommands -> Flux.fromIterable((Iterable)values).map(this::rawValue).collectList().flatMap(serialized -> listCommands.lPush(this.rawKey(key), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> leftPushIfPresent(K key, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lPushX(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> leftPush(K key, V pivot, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lInsert(this.rawKey(key), RedisListCommands.Position.BEFORE, this.rawValue(pivot), this.rawValue(value)));
    }

    @Override
    public Mono<Long> rightPush(K key, V value) {
        return this.rightPushAll(key, value);
    }

    @Override
    @SafeVarargs
    public final Mono<Long> rightPushAll(K key, V ... values) {
        Assert.notNull(values, "Values must not be null");
        return this.rightPushAll(key, (Collection<V>)Arrays.asList(values));
    }

    @Override
    public Mono<Long> rightPushAll(K key, Collection<V> values) {
        Assert.notNull(key, "Key must not be null");
        Assert.notEmpty(values, "Values must not be null or empty");
        return this.createMono(listCommands -> Flux.fromIterable((Iterable)values).map(this::rawValue).collectList().flatMap(serialized -> listCommands.rPush(this.rawKey(key), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> rightPushIfPresent(K key, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.rPushX(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> rightPush(K key, V pivot, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lInsert(this.rawKey(key), RedisListCommands.Position.AFTER, this.rawValue(pivot), this.rawValue(value)));
    }

    @Override
    public Mono<V> move(K sourceKey, ReactiveListCommands.Direction from, K destinationKey, ReactiveListCommands.Direction to) {
        Assert.notNull(sourceKey, "Source key must not be null");
        Assert.notNull(destinationKey, "Destination key must not be null");
        Assert.notNull((Object)from, "From direction must not be null");
        Assert.notNull((Object)to, "To direction must not be null");
        return this.createMono(connection -> connection.lMove(this.rawKey(sourceKey), this.rawKey(destinationKey), from, to).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> move(K sourceKey, ReactiveListCommands.Direction from, K destinationKey, ReactiveListCommands.Direction to, Duration timeout) {
        Assert.notNull(sourceKey, "Source key must not be null");
        Assert.notNull(destinationKey, "Destination key must not be null");
        Assert.notNull((Object)from, "From direction must not be null");
        Assert.notNull((Object)to, "To direction must not be null");
        Assert.notNull((Object)timeout, "Timeout must not be null");
        return this.createMono(connection -> connection.bLMove(this.rawKey(sourceKey), this.rawKey(destinationKey), from, to, timeout).map(this::readRequiredValue));
    }

    @Override
    public Mono<Boolean> set(K key, long index, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lSet(this.rawKey(key), index, this.rawValue(value)));
    }

    @Override
    public Mono<Long> remove(K key, long count, Object value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lRem(this.rawKey(key), count, this.rawValue(value)));
    }

    @Override
    public Mono<V> index(K key, long index) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(connection -> connection.lIndex(this.rawKey(key), index).map(this::readRequiredValue));
    }

    @Override
    public Mono<Long> indexOf(K key, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lPos(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> lastIndexOf(K key, V value) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.lPos(ReactiveListCommands.LPosCommand.lPosOf(this.rawValue(value)).from(this.rawKey(key)).rank(-1)));
    }

    @Override
    public Mono<V> leftPop(K key) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(connection -> connection.lPop(this.rawKey(key)).map(this::readRequiredValue));
    }

    @Override
    public Flux<V> leftPop(K key, long count) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(listCommands -> listCommands.lPop(this.rawKey(key), count).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> leftPop(K key, Duration timeout) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull((Object)timeout, "Duration must not be null");
        Assert.isTrue(this.isZeroOrGreaterOneSecond(timeout), "Duration must be either zero or greater or equal to 1 second");
        return this.createMono(connection -> connection.blPop(Collections.singletonList(this.rawKey(key)), timeout).mapNotNull(popResult -> this.readValue(popResult.getValue())));
    }

    @Override
    public Mono<V> rightPop(K key) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(listCommands -> listCommands.rPop(this.rawKey(key)).map(this::readRequiredValue));
    }

    @Override
    public Flux<V> rightPop(K key, long count) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(listCommands -> listCommands.rPop(this.rawKey(key), count).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> rightPop(K key, Duration timeout) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull((Object)timeout, "Duration must not be null");
        Assert.isTrue(this.isZeroOrGreaterOneSecond(timeout), "Duration must be either zero or greater or equal to 1 second");
        return this.createMono(connection -> connection.brPop(Collections.singletonList(this.rawKey(key)), timeout).mapNotNull(popResult -> this.readValue(popResult.getValue())));
    }

    @Override
    public Mono<V> rightPopAndLeftPush(K sourceKey, K destinationKey) {
        Assert.notNull(sourceKey, "Source key must not be null");
        Assert.notNull(destinationKey, "Destination key must not be null");
        return this.createMono(connection -> connection.rPopLPush(this.rawKey(sourceKey), this.rawKey(destinationKey)).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> rightPopAndLeftPush(K sourceKey, K destinationKey, Duration timeout) {
        Assert.notNull(sourceKey, "Source key must not be null");
        Assert.notNull(destinationKey, "Destination key must not be null");
        Assert.notNull((Object)timeout, "Duration must not be null");
        Assert.isTrue(this.isZeroOrGreaterOneSecond(timeout), "Duration must be either zero or greater or equal to 1 second");
        return this.createMono(connection -> connection.bRPopLPush(this.rawKey(sourceKey), this.rawKey(destinationKey), timeout).map(this::readRequiredValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveListCommands, Publisher<T>> function) {
        Assert.notNull(function, "Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.listCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveListCommands, Publisher<T>> function) {
        Assert.notNull(function, "Function must not be null");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.listCommands()));
    }

    private boolean isZeroOrGreaterOneSecond(Duration timeout) {
        return timeout.isZero() || (long)timeout.getNano() % TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS) == 0L;
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    @Nullable
    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private V readRequiredValue(ByteBuffer buffer) {
        V value = this.readValue(buffer);
        if (value != null) {
            return value;
        }
        throw new InvalidDataAccessApiUsageException("Deserialized list value is null");
    }
}

