/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.comparator.NullSafeComparator;

public class Bucket {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Comparator<String> COMPARATOR = new NullSafeComparator<String>(Comparator.naturalOrder(), true);
    private final NavigableMap<String, byte[]> data = new TreeMap<String, byte[]>(COMPARATOR);

    public Bucket() {
    }

    Bucket(Map<String, byte[]> data) {
        Assert.notNull(data, "Initial data must not be null");
        this.data.putAll(data);
    }

    public void put(String path, @Nullable byte[] value) {
        Assert.hasText(path, "Path to property must not be null or empty");
        this.data.put(path, value);
    }

    public void remove(String path) {
        Assert.hasText(path, "Path to property must not be null or empty");
        this.data.remove(path);
    }

    @Nullable
    public byte[] get(String path) {
        Assert.hasText(path, "Path to property must not be null or empty");
        return (byte[])this.data.get(path);
    }

    public boolean hasValue(String path) {
        return this.get(path) != null;
    }

    public Set<Map.Entry<String, byte[]>> entrySet() {
        return this.data.entrySet();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public Collection<byte[]> values() {
        return this.data.values();
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Map<String, byte[]> asMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public Bucket extract(String prefix) {
        return new Bucket(this.data.subMap(prefix, prefix + "\uffff"));
    }

    public Set<String> extractAllKeysFor(String path) {
        if (!StringUtils.hasText(path)) {
            return this.keySet();
        }
        Pattern pattern = Pattern.compile("^(" + Pattern.quote(path) + ")\\.\\[.*?\\]");
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Map.Entry entry : this.data.entrySet()) {
            Matcher matcher = pattern.matcher((CharSequence)entry.getKey());
            if (!matcher.find()) continue;
            keys.add(matcher.group());
        }
        return keys;
    }

    public Map<byte[], byte[]> rawMap() {
        LinkedHashMap<byte[], byte[]> raw = new LinkedHashMap<byte[], byte[]>(this.data.size());
        for (Map.Entry entry : this.data.entrySet()) {
            if (entry.getValue() == null) continue;
            raw.put(((String)entry.getKey()).getBytes(CHARSET), (byte[])entry.getValue());
        }
        return raw;
    }

    public BucketPropertyPath getPath() {
        return BucketPropertyPath.from(this);
    }

    public BucketPropertyPath getPropertyPath(String property) {
        return BucketPropertyPath.from(this, property);
    }

    public static Bucket newBucketFromRawMap(Map<byte[], byte[]> source) {
        Bucket bucket = new Bucket();
        for (Map.Entry<byte[], byte[]> entry : source.entrySet()) {
            bucket.put(new String(entry.getKey(), CHARSET), entry.getValue());
        }
        return bucket;
    }

    public static Bucket newBucketFromStringMap(Map<String, String> source) {
        Bucket bucket = new Bucket();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            bucket.put(entry.getKey(), StringUtils.hasText(entry.getValue()) ? entry.getValue().getBytes(CHARSET) : new byte[]{});
        }
        return bucket;
    }

    public String toString() {
        return "Bucket [data=" + this.safeToString() + "]";
    }

    private String safeToString() {
        if (this.data.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator iterator = this.data.entrySet().iterator();
        while (true) {
            Map.Entry e = iterator.next();
            sb.append((String)e.getKey());
            sb.append('=');
            sb.append(Bucket.toUtf8String((byte[])e.getValue()));
            if (!iterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Nullable
    private static String toUtf8String(byte[] raw) {
        try {
            return new String(raw, CHARSET);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class BucketPropertyPath {
        private final Bucket bucket;
        @Nullable
        private final String prefix;

        private BucketPropertyPath(Bucket bucket, String prefix) {
            Assert.notNull((Object)bucket, "Bucket must not be null");
            this.bucket = bucket;
            this.prefix = prefix;
        }

        public static BucketPropertyPath from(Bucket bucket) {
            return new BucketPropertyPath(bucket, null);
        }

        public static BucketPropertyPath from(Bucket bucket, @Nullable String prefix) {
            return new BucketPropertyPath(bucket, prefix);
        }

        @Nullable
        public byte[] get(String key) {
            return this.bucket.get(this.getPath(key));
        }

        public void put(String key, byte[] value) {
            this.bucket.put(this.getPath(key), value);
        }

        private String getPath(String key) {
            return StringUtils.hasText(this.prefix) ? this.prefix + "." + key : key;
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        @Nullable
        public String getPrefix() {
            return this.prefix;
        }
    }
}

