/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.index.IndexValueTransformer;
import org.springframework.data.redis.core.index.PathBasedRedisIndexDefinition;
import org.springframework.data.redis.core.index.RedisIndexDefinition;
import org.springframework.lang.Nullable;

public class GeoIndexDefinition
extends RedisIndexDefinition
implements PathBasedRedisIndexDefinition {
    public GeoIndexDefinition(String keyspace, String path) {
        this(keyspace, path, path);
    }

    public GeoIndexDefinition(String keyspace, String path, String name) {
        super(keyspace, path, name);
        this.addCondition(new RedisIndexDefinition.PathCondition(path));
        this.setValueTransformer(new PointValueTransformer());
    }

    static class PointValueTransformer
    implements IndexValueTransformer {
        PointValueTransformer() {
        }

        @Override
        public Point convert(@Nullable Object source) {
            if (source == null || source instanceof Point) {
                return (Point)source;
            }
            if (source instanceof RedisGeoCommands.GeoLocation) {
                return ((RedisGeoCommands.GeoLocation)source).getPoint();
            }
            throw new IllegalArgumentException(String.format("Cannot convert %s to %s; GeoIndexed property needs to be of type Point or GeoLocation", source.getClass(), Point.class));
        }
    }
}

