/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.support.collections.AbstractRedisCollection;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisIterator;
import org.springframework.data.redis.support.collections.RedisZSet;

public class DefaultRedisZSet<E>
extends AbstractRedisCollection<E>
implements RedisZSet<E> {
    private final BoundZSetOperations<String, E> boundZSetOps;
    private final double defaultScore;

    public DefaultRedisZSet(String key, RedisOperations<String, E> operations) {
        this(key, operations, 1.0);
    }

    public DefaultRedisZSet(String key, RedisOperations<String, E> operations, double defaultScore) {
        super(key, operations);
        this.boundZSetOps = operations.boundZSetOps(key);
        this.defaultScore = defaultScore;
    }

    public DefaultRedisZSet(BoundZSetOperations<String, E> boundOps) {
        this(boundOps, 1.0);
    }

    public DefaultRedisZSet(BoundZSetOperations<String, E> boundOps, double defaultScore) {
        super((String)boundOps.getKey(), boundOps.getOperations());
        this.boundZSetOps = boundOps;
        this.defaultScore = defaultScore;
    }

    @Override
    public Set<E> diff(RedisZSet<?> set) {
        return this.boundZSetOps.difference((String)set.getKey());
    }

    @Override
    public Set<E> diff(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.difference(CollectionUtils.extractKeys(sets));
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> diffWithScores(RedisZSet<?> set) {
        return this.boundZSetOps.differenceWithScores((String)set.getKey());
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> diffWithScores(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.differenceWithScores(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisZSet<E> diffAndStore(RedisZSet<?> set, String destKey) {
        this.boundZSetOps.differenceAndStore((String)set.getKey(), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public RedisZSet<E> diffAndStore(Collection<? extends RedisZSet<?>> sets, String destKey) {
        this.boundZSetOps.differenceAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public Set<E> intersect(RedisZSet<?> set) {
        return this.boundZSetOps.intersect((String)set.getKey());
    }

    @Override
    public Set<E> intersect(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.intersect(CollectionUtils.extractKeys(sets));
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> intersectWithScores(RedisZSet<?> set) {
        return this.boundZSetOps.intersectWithScores((String)set.getKey());
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> intersectWithScores(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.intersectWithScores(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisZSet<E> intersectAndStore(RedisZSet<?> set, String destKey) {
        this.boundZSetOps.intersectAndStore((String)set.getKey(), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public RedisZSet<E> intersectAndStore(Collection<? extends RedisZSet<?>> sets, String destKey) {
        this.boundZSetOps.intersectAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public Set<E> union(RedisZSet<?> set) {
        return this.boundZSetOps.union((String)set.getKey());
    }

    @Override
    public Set<E> union(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.union(CollectionUtils.extractKeys(sets));
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> unionWithScores(RedisZSet<?> set) {
        return this.boundZSetOps.unionWithScores((String)set.getKey());
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> unionWithScores(Collection<? extends RedisZSet<?>> sets) {
        return this.boundZSetOps.unionWithScores(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisZSet<E> unionAndStore(RedisZSet<?> set, String destKey) {
        this.boundZSetOps.unionAndStore((String)set.getKey(), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public RedisZSet<E> unionAndStore(Collection<? extends RedisZSet<?>> sets, String destKey) {
        this.boundZSetOps.unionAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public E randomValue() {
        return this.boundZSetOps.randomMember();
    }

    @Override
    public Set<E> range(long start, long end) {
        return this.boundZSetOps.range(start, end);
    }

    @Override
    public Set<E> reverseRange(long start, long end) {
        return this.boundZSetOps.reverseRange(start, end);
    }

    @Override
    public Set<E> rangeByLex(Range<String> range, Limit limit) {
        return this.boundZSetOps.rangeByLex(range, limit);
    }

    @Override
    public Set<E> reverseRangeByLex(Range<String> range, Limit limit) {
        return this.boundZSetOps.reverseRangeByLex(range, limit);
    }

    @Override
    public Set<E> rangeByScore(double min, double max) {
        return this.boundZSetOps.rangeByScore(min, max);
    }

    @Override
    public Set<E> reverseRangeByScore(double min, double max) {
        return this.boundZSetOps.reverseRangeByScore(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> rangeByScoreWithScores(double min, double max) {
        return this.boundZSetOps.rangeByScoreWithScores(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> rangeWithScores(long start, long end) {
        return this.boundZSetOps.rangeWithScores(start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> reverseRangeByScoreWithScores(double min, double max) {
        return this.boundZSetOps.reverseRangeByScoreWithScores(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> reverseRangeWithScores(long start, long end) {
        return this.boundZSetOps.reverseRangeWithScores(start, end);
    }

    @Override
    public RedisZSet<E> rangeAndStoreByLex(String dstKey, Range<String> range, Limit limit) {
        this.boundZSetOps.rangeAndStoreByLex(dstKey, range, limit);
        return new DefaultRedisZSet(this.getOperations().boundZSetOps(dstKey));
    }

    @Override
    public RedisZSet<E> reverseRangeAndStoreByLex(String dstKey, Range<String> range, Limit limit) {
        this.boundZSetOps.reverseRangeAndStoreByLex(dstKey, range, limit);
        return new DefaultRedisZSet(this.getOperations().boundZSetOps(dstKey));
    }

    @Override
    public RedisZSet<E> rangeAndStoreByScore(String dstKey, Range<? extends Number> range, Limit limit) {
        this.boundZSetOps.rangeAndStoreByScore(dstKey, range, limit);
        return new DefaultRedisZSet(this.getOperations().boundZSetOps(dstKey));
    }

    @Override
    public RedisZSet<E> reverseRangeAndStoreByScore(String dstKey, Range<? extends Number> range, Limit limit) {
        this.boundZSetOps.reverseRangeAndStoreByScore(dstKey, range, limit);
        return new DefaultRedisZSet(this.getOperations().boundZSetOps(dstKey));
    }

    @Override
    public RedisZSet<E> remove(long start, long end) {
        this.boundZSetOps.removeRange(start, end);
        return this;
    }

    @Override
    public RedisZSet<E> removeByLex(Range<String> range) {
        this.boundZSetOps.removeRangeByLex(range);
        return this;
    }

    @Override
    public RedisZSet<E> removeByScore(double min, double max) {
        this.boundZSetOps.removeRangeByScore(min, max);
        return this;
    }

    @Override
    public boolean add(E e) {
        Boolean result = this.add(e, this.getDefaultScore());
        this.checkResult(result);
        return result;
    }

    @Override
    public boolean add(E e, double score) {
        Boolean result = this.boundZSetOps.add(e, score);
        this.checkResult(result);
        return result;
    }

    @Override
    public boolean addIfAbsent(E e, double score) {
        Boolean result = this.boundZSetOps.addIfAbsent(e, score);
        this.checkResult(result);
        return result;
    }

    @Override
    public void clear() {
        this.boundZSetOps.removeRange(0L, -1L);
    }

    @Override
    public boolean contains(Object o) {
        return this.boundZSetOps.rank(o) != null;
    }

    @Override
    public Iterator<E> iterator() {
        Set<E> members = this.boundZSetOps.range(0L, -1L);
        this.checkResult(members);
        return new DefaultRedisSortedSetIterator(members.iterator());
    }

    @Override
    public boolean remove(Object o) {
        Long result = this.boundZSetOps.remove(o);
        this.checkResult(result);
        return result == 1L;
    }

    @Override
    public int size() {
        Long result = this.boundZSetOps.size();
        this.checkResult(result);
        return result.intValue();
    }

    @Override
    public Double getDefaultScore() {
        return this.defaultScore;
    }

    @Override
    public E first() {
        Set<E> members = this.boundZSetOps.range(0L, 0L);
        this.checkResult(members);
        Iterator<E> iterator = members.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E popFirst() {
        ZSetOperations.TypedTuple<E> tuple = this.boundZSetOps.popMin();
        if (tuple != null) {
            return tuple.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E popFirst(long timeout, TimeUnit unit) {
        ZSetOperations.TypedTuple<E> tuple = this.boundZSetOps.popMin(timeout, unit);
        if (tuple != null) {
            return tuple.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() {
        Set<E> members = this.boundZSetOps.reverseRange(0L, 0L);
        this.checkResult(members);
        Iterator<E> iterator = members.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E popLast() {
        ZSetOperations.TypedTuple<E> tuple = this.boundZSetOps.popMax();
        if (tuple != null) {
            return tuple.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E popLast(long timeout, TimeUnit unit) {
        ZSetOperations.TypedTuple<E> tuple = this.boundZSetOps.popMax(timeout, unit);
        if (tuple != null) {
            return tuple.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long rank(Object o) {
        return this.boundZSetOps.rank(o);
    }

    @Override
    public Long reverseRank(Object o) {
        return this.boundZSetOps.reverseRank(o);
    }

    @Override
    public Long lexCount(Range<String> range) {
        return this.boundZSetOps.lexCount(range);
    }

    @Override
    public Double score(Object o) {
        return this.boundZSetOps.score(o);
    }

    @Override
    public DataType getType() {
        return DataType.ZSET;
    }

    @Override
    public Cursor<E> scan() {
        return new ConvertingCursor<ZSetOperations.TypedTuple, Object>(this.scan(ScanOptions.NONE), ZSetOperations.TypedTuple::getValue);
    }

    public Cursor<ZSetOperations.TypedTuple<E>> scan(ScanOptions options) {
        return this.boundZSetOps.scan(options);
    }

    private class DefaultRedisSortedSetIterator
    extends RedisIterator<E> {
        public DefaultRedisSortedSetIterator(Iterator<E> delegate) {
            super(delegate);
        }

        @Override
        protected void removeFromRedisStorage(E item) {
            DefaultRedisZSet.this.remove(item);
        }
    }
}

