/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SimpleTypeInformationMapper
implements TypeInformationMapper,
BeanClassLoaderAware {
    private final Map<String, Optional<TypeInformation<?>>> cache = new ConcurrentHashMap();
    @Nullable
    private ClassLoader classLoader;

    @Override
    @Nullable
    public TypeInformation<?> resolveTypeFrom(Alias alias) {
        String stringAlias = alias.mapTyped(String.class);
        if (stringAlias != null) {
            return this.cache.computeIfAbsent(stringAlias, this::loadClass).orElse(null);
        }
        return null;
    }

    @Override
    public Alias createAliasFor(TypeInformation<?> type) {
        return Alias.of(type.getType().getName());
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Optional<TypeInformation<?>> loadClass(String typeName) {
        try {
            return Optional.of(TypeInformation.of(ClassUtils.forName(typeName, this.classLoader)));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

