/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveHashCommands {
    default public Mono<Boolean> hSet(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)field, "Field must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hSetNX(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)field, "Field must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key).ifValueNotExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hMSet(ByteBuffer key, Map<ByteBuffer, ByteBuffer> fieldValueMap) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(fieldValueMap, "Field must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.fieldValues(fieldValueMap).forKey(key))).next().map(it -> true);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HSetCommand>> hSet(Publisher<HSetCommand> var1);

    default public Mono<ByteBuffer> hGet(ByteBuffer key, ByteBuffer field) {
        return this.hMGet(key, Collections.singletonList(field)).filter(it -> !it.contains(null)).flatMapIterable(Function.identity()).next();
    }

    default public Mono<List<ByteBuffer>> hMGet(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(fields, "Fields must not be null");
        return this.hMGet((Publisher<HGetCommand>)Mono.just((Object)HGetCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<HGetCommand, ByteBuffer>> hMGet(Publisher<HGetCommand> var1);

    default public Mono<Boolean> hExists(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)field, "Field must not be null");
        return this.hExists((Publisher<HExistsCommand>)Mono.just((Object)HExistsCommand.field(field).in(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HExistsCommand>> hExists(Publisher<HExistsCommand> var1);

    default public Mono<Boolean> hDel(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)field, "Field must not be null");
        return this.hDel(key, Collections.singletonList(field)).map(val -> val > 0L ? Boolean.TRUE : Boolean.FALSE);
    }

    default public Mono<Long> hDel(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(fields, "Fields must not be null");
        return this.hDel((Publisher<HDelCommand>)Mono.just((Object)HDelCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HDelCommand, Long>> hDel(Publisher<HDelCommand> var1);

    default public Mono<Long> hLen(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hLen((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<ByteBuffer> hRandField(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hRandField((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(1L))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Mono<Map.Entry<ByteBuffer, ByteBuffer>> hRandFieldWithValues(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hRandFieldWithValues((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(1L))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Flux<ByteBuffer> hRandField(ByteBuffer key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hRandField((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hRandFieldWithValues(ByteBuffer key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hRandFieldWithValues((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<HRandFieldCommand, Flux<ByteBuffer>>> hRandField(Publisher<HRandFieldCommand> var1);

    public Flux<ReactiveRedisConnection.CommandResponse<HRandFieldCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hRandFieldWithValues(Publisher<HRandFieldCommand> var1);

    default public Flux<ByteBuffer> hKeys(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hKeys((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<ByteBuffer> hVals(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hVals((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hGetAll(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.hGetAll((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hScan(ByteBuffer key) {
        return this.hScan(key, ScanOptions.NONE);
    }

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hScan(ByteBuffer key, ScanOptions options) {
        return this.hScan((Publisher<ReactiveRedisConnection.KeyScanCommand>)Mono.just((Object)ReactiveRedisConnection.KeyScanCommand.key(key).withOptions(options))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(it -> it);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> var1);

    default public Mono<Long> hStrLen(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)field, "Field must not be null");
        return this.hStrLen((Publisher<HStrLenCommand>)Mono.just((Object)HStrLenCommand.lengthOf(field).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HStrLenCommand, Long>> hStrLen(Publisher<HStrLenCommand> var1);

    public static class HSetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private static final ByteBuffer SINGLE_VALUE_KEY = ByteBuffer.allocate(0);
        private final Map<ByteBuffer, ByteBuffer> fieldValueMap;
        private final boolean upsert;

        private HSetCommand(@Nullable ByteBuffer key, Map<ByteBuffer, ByteBuffer> keyValueMap, boolean upsert) {
            super(key);
            this.fieldValueMap = keyValueMap;
            this.upsert = upsert;
        }

        public static HSetCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new HSetCommand(null, Collections.singletonMap(SINGLE_VALUE_KEY, value), Boolean.TRUE);
        }

        public static HSetCommand fieldValues(Map<ByteBuffer, ByteBuffer> fieldValueMap) {
            Assert.notNull(fieldValueMap, "Field values map must not be null");
            return new HSetCommand(null, fieldValueMap, Boolean.TRUE);
        }

        public HSetCommand ofField(ByteBuffer field) {
            if (!this.fieldValueMap.containsKey(SINGLE_VALUE_KEY)) {
                throw new InvalidDataAccessApiUsageException("Value has not been set.");
            }
            Assert.notNull((Object)field, "Field not be null");
            return new HSetCommand(this.getKey(), Collections.singletonMap(field, this.fieldValueMap.get(SINGLE_VALUE_KEY)), this.upsert);
        }

        public HSetCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, "Key not be null");
            return new HSetCommand(key, this.fieldValueMap, this.upsert);
        }

        public HSetCommand ifValueNotExists() {
            return new HSetCommand(this.getKey(), this.fieldValueMap, Boolean.FALSE);
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public Map<ByteBuffer, ByteBuffer> getFieldValueMap() {
            return this.fieldValueMap;
        }
    }

    public static class HGetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private List<ByteBuffer> fields;

        private HGetCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key);
            this.fields = fields;
        }

        public static HGetCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, "Field must not be null");
            return new HGetCommand(null, Collections.singletonList(field));
        }

        public static HGetCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, "Fields must not be null");
            return new HGetCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HGetCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null");
            return new HGetCommand(key, this.fields);
        }

        public List<ByteBuffer> getFields() {
            return this.fields;
        }
    }

    public static class HExistsCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer field;

        private HExistsCommand(@Nullable ByteBuffer key, ByteBuffer field) {
            super(key);
            this.field = field;
        }

        public static HExistsCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, "Field must not be null");
            return new HExistsCommand(null, field);
        }

        public HExistsCommand in(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null");
            return new HExistsCommand(key, this.field);
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }

    public static class HDelCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> fields;

        private HDelCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key);
            this.fields = fields;
        }

        public static HDelCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, "Field must not be null");
            return new HDelCommand(null, Collections.singletonList(field));
        }

        public static HDelCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, "Fields must not be null");
            return new HDelCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HDelCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null");
            return new HDelCommand(key, this.fields);
        }

        public List<ByteBuffer> getFields() {
            return this.fields;
        }
    }

    public static class HRandFieldCommand
    extends ReactiveRedisConnection.KeyCommand {
        private long count;

        private HRandFieldCommand(@Nullable ByteBuffer key, long count) {
            super(key);
            this.count = count;
        }

        public static HRandFieldCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null");
            return new HRandFieldCommand(key, 1L);
        }

        public HRandFieldCommand count(long count) {
            return new HRandFieldCommand(this.getKey(), count);
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class HStrLenCommand
    extends ReactiveRedisConnection.KeyCommand {
        private ByteBuffer field;

        private HStrLenCommand(@Nullable ByteBuffer key, ByteBuffer field) {
            super(key);
            this.field = field;
        }

        public static HStrLenCommand lengthOf(ByteBuffer field) {
            Assert.notNull((Object)field, "Field must not be null");
            return new HStrLenCommand(null, field);
        }

        public HStrLenCommand from(ByteBuffer key) {
            return new HStrLenCommand(key, this.field);
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }
}

