/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.util.RedisAssertions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisClusterConfiguration
implements RedisConfiguration,
RedisConfiguration.ClusterConfiguration {
    private static final String REDIS_CLUSTER_NODES_CONFIG_PROPERTY = "spring.redis.cluster.nodes";
    private static final String REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY = "spring.redis.cluster.max-redirects";
    @Nullable
    private Integer maxRedirects;
    private RedisPassword password = RedisPassword.none();
    private final Set<RedisNode> clusterNodes = new LinkedHashSet<RedisNode>();
    @Nullable
    private String username = null;

    public RedisClusterConfiguration() {
    }

    public RedisClusterConfiguration(Collection<String> clusterNodes) {
        this.initialize(new MapPropertySource("RedisClusterConfiguration", RedisClusterConfiguration.asMap(clusterNodes, -1)));
    }

    @Deprecated(since="3.3")
    public RedisClusterConfiguration(PropertySource<?> propertySource) {
        this.initialize(propertySource);
    }

    private void initialize(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, "PropertySource must not be null");
        if (propertySource.containsProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY)) {
            Object redisClusterNodes = propertySource.getProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY);
            this.appendClusterNodes(StringUtils.commaDelimitedListToSet(String.valueOf(redisClusterNodes)));
        }
        if (propertySource.containsProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY)) {
            Object clusterMaxRedirects = propertySource.getProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY);
            this.maxRedirects = NumberUtils.parseNumber(String.valueOf(clusterMaxRedirects), Integer.class);
        }
    }

    public static RedisClusterConfiguration of(PropertySource<?> propertySource) {
        return new RedisClusterConfiguration(propertySource);
    }

    private void appendClusterNodes(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addClusterNode(RedisNode.fromString(hostAndPort));
        }
    }

    public void setClusterNodes(Iterable<RedisNode> nodes) {
        Assert.notNull(nodes, "Cannot set cluster nodes to null");
        this.clusterNodes.clear();
        for (RedisNode clusterNode : nodes) {
            this.addClusterNode(clusterNode);
        }
    }

    @Override
    public Set<RedisNode> getClusterNodes() {
        return Collections.unmodifiableSet(this.clusterNodes);
    }

    public void addClusterNode(RedisNode node) {
        this.clusterNodes.add(RedisAssertions.requireNonNull(node, "ClusterNode must not be null", new Object[0]));
    }

    public RedisClusterConfiguration clusterNode(String host, Integer port) {
        return this.clusterNode(new RedisNode(host, port));
    }

    public RedisClusterConfiguration clusterNode(RedisNode node) {
        this.clusterNodes.add(node);
        return this;
    }

    public void setMaxRedirects(int maxRedirects) {
        Assert.isTrue(maxRedirects >= 0, "MaxRedirects must be greater or equal to 0");
        this.maxRedirects = maxRedirects;
    }

    @Override
    public Integer getMaxRedirects() {
        return this.maxRedirects != null && this.maxRedirects > Integer.MIN_VALUE ? this.maxRedirects : null;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(RedisPassword password) {
        this.password = RedisAssertions.requireNonNull(password, "RedisPassword must not be null", new Object[0]);
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RedisClusterConfiguration)) {
            return false;
        }
        RedisClusterConfiguration that = (RedisClusterConfiguration)obj;
        return ObjectUtils.nullSafeEquals(this.clusterNodes, that.clusterNodes) && ObjectUtils.nullSafeEquals(this.maxRedirects, that.maxRedirects) && ObjectUtils.nullSafeEquals(this.username, that.username) && ObjectUtils.nullSafeEquals(this.password, that.password);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.clusterNodes);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.maxRedirects);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.username);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.password);
        return result;
    }

    private static Map<String, Object> asMap(Collection<String> clusterHostAndPorts, int redirects) {
        Assert.notNull(clusterHostAndPorts, "ClusterHostAndPorts must not be null");
        Assert.noNullElements(clusterHostAndPorts, "ClusterHostAndPorts must not contain null elements");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_CLUSTER_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(clusterHostAndPorts));
        if (redirects >= 0) {
            map.put(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY, redirects);
        }
        return map;
    }
}

