/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public interface RedisStreamCommands {
    @Nullable
    default public Long xAck(byte[] key, String group, String ... recordIds) {
        return this.xAck(key, group, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    @Nullable
    public Long xAck(byte[] var1, String var2, RecordId ... var3);

    @Nullable
    default public RecordId xAdd(byte[] key, Map<byte[], byte[]> content) {
        return this.xAdd(StreamRecords.newRecord().in(key).ofMap(content));
    }

    @Nullable
    default public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        return this.xAdd(record, XAddOptions.none());
    }

    @Nullable
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> var1, XAddOptions var2);

    @Nullable
    public List<RecordId> xClaimJustId(byte[] var1, String var2, String var3, XClaimOptions var4);

    @Nullable
    default public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, Duration minIdleTime, RecordId ... recordIds) {
        return this.xClaim(key, group, newOwner, XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    @Nullable
    public List<ByteRecord> xClaim(byte[] var1, String var2, String var3, XClaimOptions var4);

    @Nullable
    default public Long xDel(byte[] key, String ... recordIds) {
        return this.xDel(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    @Nullable
    public Long xDel(byte[] var1, RecordId ... var2);

    @Nullable
    public String xGroupCreate(byte[] var1, String var2, ReadOffset var3);

    @Nullable
    public String xGroupCreate(byte[] var1, String var2, ReadOffset var3, boolean var4);

    @Nullable
    default public Boolean xGroupDelConsumer(byte[] key, String groupName, String consumerName) {
        return this.xGroupDelConsumer(key, Consumer.from(groupName, consumerName));
    }

    @Nullable
    public Boolean xGroupDelConsumer(byte[] var1, Consumer var2);

    @Nullable
    public Boolean xGroupDestroy(byte[] var1, String var2);

    @Nullable
    public StreamInfo.XInfoStream xInfo(byte[] var1);

    @Nullable
    public StreamInfo.XInfoGroups xInfoGroups(byte[] var1);

    @Nullable
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] var1, String var2);

    @Nullable
    public Long xLen(byte[] var1);

    @Nullable
    public PendingMessagesSummary xPending(byte[] var1, String var2);

    @Nullable
    default public PendingMessages xPending(byte[] key, Consumer consumer) {
        return this.xPending(key, consumer.getGroup(), consumer.getName());
    }

    @Nullable
    default public PendingMessages xPending(byte[] key, String groupName, String consumerName) {
        return this.xPending(key, groupName, XPendingOptions.unbounded().consumer(consumerName));
    }

    @Nullable
    default public PendingMessages xPending(byte[] key, String groupName, Range<?> range, Long count) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count));
    }

    @Nullable
    default public PendingMessages xPending(byte[] key, Consumer consumer, Range<?> range, Long count) {
        return this.xPending(key, consumer.getGroup(), consumer.getName(), range, count);
    }

    @Nullable
    default public PendingMessages xPending(byte[] key, String groupName, String consumerName, Range<?> range, Long count) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count).consumer(consumerName));
    }

    @Nullable
    public PendingMessages xPending(byte[] var1, String var2, XPendingOptions var3);

    @Nullable
    default public List<ByteRecord> xRange(byte[] key, Range<String> range) {
        return this.xRange(key, range, Limit.unlimited());
    }

    @Nullable
    public List<ByteRecord> xRange(byte[] var1, Range<String> var2, Limit var3);

    @Nullable
    default public List<ByteRecord> xRead(StreamOffset<byte[]> ... streams) {
        return this.xRead(StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<ByteRecord> xRead(StreamReadOptions var1, StreamOffset<byte[]> ... var2);

    @Nullable
    default public List<ByteRecord> xReadGroup(Consumer consumer, StreamOffset<byte[]> ... streams) {
        return this.xReadGroup(consumer, StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<ByteRecord> xReadGroup(Consumer var1, StreamReadOptions var2, StreamOffset<byte[]> ... var3);

    @Nullable
    default public List<ByteRecord> xRevRange(byte[] key, Range<String> range) {
        return this.xRevRange(key, range, Limit.unlimited());
    }

    @Nullable
    public List<ByteRecord> xRevRange(byte[] var1, Range<String> var2, Limit var3);

    @Nullable
    public Long xTrim(byte[] var1, long var2);

    @Nullable
    public Long xTrim(byte[] var1, long var2, boolean var4);

    public static class XAddOptions {
        private static final XAddOptions NONE = new XAddOptions(null, false, false, null);
        @Nullable
        private final Long maxlen;
        private final boolean nomkstream;
        private final boolean approximateTrimming;
        @Nullable
        private final RecordId minId;

        private XAddOptions(@Nullable Long maxlen, boolean nomkstream, boolean approximateTrimming, @Nullable RecordId minId) {
            this.maxlen = maxlen;
            this.nomkstream = nomkstream;
            this.approximateTrimming = approximateTrimming;
            this.minId = minId;
        }

        public static XAddOptions none() {
            return NONE;
        }

        public static XAddOptions makeNoStream() {
            return new XAddOptions(null, true, false, null);
        }

        public static XAddOptions makeNoStream(boolean makeNoStream) {
            return new XAddOptions(null, makeNoStream, false, null);
        }

        public static XAddOptions maxlen(long maxlen) {
            return new XAddOptions(maxlen, false, false, null);
        }

        public XAddOptions minId(RecordId minId) {
            return new XAddOptions(this.maxlen, this.nomkstream, this.approximateTrimming, minId);
        }

        public XAddOptions approximateTrimming(boolean approximateTrimming) {
            return new XAddOptions(this.maxlen, this.nomkstream, approximateTrimming, this.minId);
        }

        public boolean isNoMkStream() {
            return this.nomkstream;
        }

        @Nullable
        public Long getMaxlen() {
            return this.maxlen;
        }

        public boolean hasMaxlen() {
            return this.maxlen != null && this.maxlen > 0L;
        }

        public boolean isApproximateTrimming() {
            return this.approximateTrimming;
        }

        @Nullable
        public RecordId getMinId() {
            return this.minId;
        }

        public boolean hasMinId() {
            return this.minId != null;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XAddOptions)) {
                return false;
            }
            XAddOptions that = (XAddOptions)o;
            if (this.nomkstream != that.nomkstream) {
                return false;
            }
            if (this.approximateTrimming != that.approximateTrimming) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.maxlen, that.maxlen)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.minId, that.minId);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.maxlen);
            result = 31 * result + (this.nomkstream ? 1 : 0);
            result = 31 * result + (this.approximateTrimming ? 1 : 0);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.minId);
            return result;
        }
    }

    public static class XClaimOptions {
        private final List<RecordId> ids;
        private final Duration minIdleTime;
        @Nullable
        private final Duration idleTime;
        @Nullable
        private final Instant unixTime;
        @Nullable
        private final Long retryCount;
        private final boolean force;

        private XClaimOptions(List<RecordId> ids, Duration minIdleTime, @Nullable Duration idleTime, @Nullable Instant unixTime, @Nullable Long retryCount, boolean force) {
            this.ids = new ArrayList<RecordId>(ids);
            this.minIdleTime = minIdleTime;
            this.idleTime = idleTime;
            this.unixTime = unixTime;
            this.retryCount = retryCount;
            this.force = force;
        }

        public static XClaimOptionsBuilder minIdle(Duration minIdleTime) {
            return new XClaimOptionsBuilder(minIdleTime);
        }

        public static XClaimOptionsBuilder minIdleMs(long millis) {
            return XClaimOptions.minIdle(Duration.ofMillis(millis));
        }

        public XClaimOptions idle(Duration idleTime) {
            return new XClaimOptions(this.ids, this.minIdleTime, idleTime, this.unixTime, this.retryCount, this.force);
        }

        public XClaimOptions time(Instant unixTime) {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, unixTime, this.retryCount, this.force);
        }

        public XClaimOptions retryCount(long retryCount) {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, this.unixTime, retryCount, this.force);
        }

        public XClaimOptions force() {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, this.unixTime, this.retryCount, true);
        }

        public List<RecordId> getIds() {
            return this.ids;
        }

        public String[] getIdsAsStringArray() {
            return (String[])this.getIds().stream().map(RecordId::getValue).toArray(String[]::new);
        }

        public Duration getMinIdleTime() {
            return this.minIdleTime;
        }

        @Nullable
        public Duration getIdleTime() {
            return this.idleTime;
        }

        @Nullable
        public Instant getUnixTime() {
            return this.unixTime;
        }

        @Nullable
        public Long getRetryCount() {
            return this.retryCount;
        }

        public boolean isForce() {
            return this.force;
        }

        public static class XClaimOptionsBuilder {
            private final Duration minIdleTime;

            XClaimOptionsBuilder(Duration minIdleTime) {
                Assert.notNull((Object)minIdleTime, "Min idle time must not be null");
                this.minIdleTime = minIdleTime;
            }

            public XClaimOptions ids(List<?> ids) {
                List<RecordId> idList = ids.stream().map(it -> it instanceof RecordId ? (RecordId)it : RecordId.of(it.toString())).collect(Collectors.toList());
                return new XClaimOptions(idList, this.minIdleTime, null, null, null, false);
            }

            public XClaimOptions ids(RecordId ... ids) {
                return this.ids(Arrays.asList(ids));
            }

            public XClaimOptions ids(String ... ids) {
                return this.ids(Arrays.asList(ids));
            }
        }
    }

    public static class XPendingOptions {
        @Nullable
        private final String consumerName;
        private final Range<?> range;
        @Nullable
        private final Long count;

        private XPendingOptions(@Nullable String consumerName, Range<?> range, @Nullable Long count) {
            this.range = range;
            this.count = count;
            this.consumerName = consumerName;
        }

        public static XPendingOptions unbounded() {
            return new XPendingOptions(null, Range.unbounded(), null);
        }

        public static XPendingOptions unbounded(Long count) {
            return new XPendingOptions(null, Range.unbounded(), count);
        }

        public static XPendingOptions range(Range<?> range, Long count) {
            return new XPendingOptions(null, range, count);
        }

        public XPendingOptions consumer(String consumerName) {
            return new XPendingOptions(consumerName, this.range, this.count);
        }

        public Range<?> getRange() {
            return this.range;
        }

        @Nullable
        public Long getCount() {
            return this.count;
        }

        @Nullable
        public String getConsumerName() {
            return this.consumerName;
        }

        public boolean hasConsumer() {
            return StringUtils.hasText(this.consumerName);
        }

        public boolean isLimited() {
            return this.count != null && this.count > -1L;
        }
    }
}

