/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.commands.ListBinaryCommands;
import redis.clients.jedis.commands.ListPipelineBinaryCommands;
import redis.clients.jedis.params.LPosParams;

class JedisListCommands
implements RedisListCommands {
    private final JedisConnection connection;

    JedisListCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpush, ListPipelineBinaryCommands::rpush, key, values);
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)element, "Element must not be null");
        LPosParams params = new LPosParams();
        if (rank != null) {
            params.rank(rank);
        }
        if (count != null) {
            return this.connection.invoke().just(ListBinaryCommands::lpos, ListPipelineBinaryCommands::lpos, key, element, params, count);
        }
        return this.connection.invoke().from(ListBinaryCommands::lpos, ListPipelineBinaryCommands::lpos, key, element, params).getOrElse(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Values must not be null");
        Assert.noNullElements((Object[])values, "Values must not contain null elements");
        return this.connection.invoke().just(ListBinaryCommands::lpush, ListPipelineBinaryCommands::lpush, key, values);
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.rpushx((byte[])x$0, new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.rpushx((byte[])x$0, new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.lpushx((byte[])x$0, new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.lpushx((byte[])x$0, new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::llen, ListPipelineBinaryCommands::llen, key);
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lrange, ListPipelineBinaryCommands::lrange, key, start, end);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        this.connection.invokeStatus().just(ListBinaryCommands::ltrim, ListPipelineBinaryCommands::ltrim, key, start, end);
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lindex, ListPipelineBinaryCommands::lindex, key, index);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::linsert, ListPipelineBinaryCommands::linsert, key, JedisConverters.toListPosition(where), pivot, value);
    }

    @Override
    public byte[] lMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, "Source key must not be null");
        Assert.notNull((Object)destinationKey, "Destination key must not be null");
        Assert.notNull((Object)from, "From direction must not be null");
        Assert.notNull((Object)to, "To direction must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lmove, ListPipelineBinaryCommands::lmove, sourceKey, destinationKey, ListDirection.valueOf(from.name()), ListDirection.valueOf(to.name()));
    }

    @Override
    public byte[] bLMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, "Source key must not be null");
        Assert.notNull((Object)destinationKey, "Destination key must not be null");
        Assert.notNull((Object)from, "From direction must not be null");
        Assert.notNull((Object)to, "To direction must not be null");
        return this.connection.invoke().just(ListBinaryCommands::blmove, ListPipelineBinaryCommands::blmove, sourceKey, destinationKey, ListDirection.valueOf(from.name()), ListDirection.valueOf(to.name()), timeout);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        this.connection.invokeStatus().just(ListBinaryCommands::lset, ListPipelineBinaryCommands::lset, key, index, value);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lrem, ListPipelineBinaryCommands::lrem, key, count, value);
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lpop, ListPipelineBinaryCommands::lpop, key);
    }

    @Override
    public List<byte[]> lPop(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lpop, ListPipelineBinaryCommands::lpop, key, (int)count);
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpop, ListPipelineBinaryCommands::rpop, key);
    }

    @Override
    public List<byte[]> rPop(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpop, ListPipelineBinaryCommands::rpop, key, (int)count);
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Key must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(j -> j.blpop(timeout, keys), j -> j.blpop(timeout, keys));
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Key must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(j -> j.brpop(timeout, keys), j -> j.brpop(timeout, keys));
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpoplpush, ListPipelineBinaryCommands::rpoplpush, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::brpoplpush, ListPipelineBinaryCommands::brpoplpush, srcKey, dstKey, timeout);
    }
}

