/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceFutureUtils {
    LettuceFutureUtils() {
    }

    static <T> CompletableFuture<T> failed(Throwable throwable) {
        Assert.notNull((Object)throwable, "Throwable must not be null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    @Nullable
    static <T> T join(CompletionStage<T> future) throws RuntimeException, CompletionException {
        Assert.notNull(future, "CompletableFuture must not be null");
        try {
            return future.toCompletableFuture().join();
        }
        catch (Exception ex) {
            Throwable exceptionToUse = ex;
            if (ex instanceof CompletionException && (exceptionToUse = LettuceExceptionConverter.INSTANCE.convert((Exception)ex.getCause())) == null) {
                exceptionToUse = ex.getCause();
            }
            if (exceptionToUse instanceof RuntimeException) {
                throw (RuntimeException)exceptionToUse;
            }
            throw new CompletionException(exceptionToUse);
        }
    }

    static <T> Function<Throwable, T> ignoreErrors() {
        return ignored -> null;
    }
}

