/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.ReactiveRedisCallback;
import org.springframework.data.redis.core.script.ReactiveScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptUtils;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveScriptExecutor<K>
implements ReactiveScriptExecutor<K> {
    private final ReactiveRedisConnectionFactory connectionFactory;
    private final RedisSerializationContext<K, ?> serializationContext;

    public DefaultReactiveScriptExecutor(ReactiveRedisConnectionFactory connectionFactory, RedisSerializationContext<K, ?> serializationContext) {
        Assert.notNull((Object)connectionFactory, "ReactiveRedisConnectionFactory must not be null");
        Assert.notNull(serializationContext, "RedisSerializationContext must not be null");
        this.connectionFactory = connectionFactory;
        this.serializationContext = serializationContext;
    }

    @Override
    public <T> Flux<T> execute(RedisScript<T> script, List<K> keys, List<?> args) {
        Assert.notNull(script, "RedisScript must not be null");
        Assert.notNull(keys, "Keys must not be null");
        Assert.notNull(args, "Args must not be null");
        RedisSerializationContext.SerializationPair<?> serializationPair = this.serializationContext.getValueSerializationPair();
        return this.execute(script, keys, args, serializationPair.getWriter(), serializationPair.getReader());
    }

    @Override
    public <T> Flux<T> execute(RedisScript<T> script, List<K> keys, List<?> args, RedisElementWriter<?> argsWriter, RedisElementReader<T> resultReader) {
        Assert.notNull(script, "RedisScript must not be null");
        Assert.notNull(argsWriter, "Argument Writer must not be null");
        Assert.notNull(resultReader, "Result Reader must not be null");
        Assert.notNull(keys, "Keys must not be null");
        Assert.notNull(args, "Args must not be null");
        return this.execute((ReactiveRedisConnection connection) -> {
            ReturnType returnType = ReturnType.fromJavaType(script.getResultType());
            ByteBuffer[] keysAndArgs = this.keysAndArgs(argsWriter, keys, args);
            int keySize = keys.size();
            return this.eval(connection, script, returnType, keySize, keysAndArgs, resultReader);
        });
    }

    protected <T> Flux<T> eval(ReactiveRedisConnection connection, RedisScript<T> script, ReturnType returnType, int numKeys, ByteBuffer[] keysAndArgs, RedisElementReader<T> resultReader) {
        Flux<T> result = connection.scriptingCommands().evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
        result = result.onErrorResume(cause -> {
            if (ScriptUtils.exceptionContainsNoScriptError(cause)) {
                return connection.scriptingCommands().eval(this.scriptBytes(script), returnType, numKeys, keysAndArgs);
            }
            return Flux.error((Throwable)(cause instanceof RuntimeException ? cause : new RedisSystemException(cause.getMessage(), (Throwable)cause)));
        });
        return script.returnsRawValue() ? result : this.deserializeResult(resultReader, result);
    }

    protected ByteBuffer[] keysAndArgs(RedisElementWriter argsWriter, List<K> keys, List<?> args) {
        return (ByteBuffer[])Stream.concat(keys.stream().map(t -> this.keySerializer().getWriter().write(t)), args.stream().map(t -> argsWriter.write(t))).toArray(ByteBuffer[]::new);
    }

    protected ByteBuffer scriptBytes(RedisScript<?> script) {
        return this.serializationContext.getStringSerializationPair().getWriter().write(script.getScriptAsString());
    }

    protected <T> Flux<T> deserializeResult(RedisElementReader<T> reader, Flux<T> result) {
        return result.map(it -> {
            Object value = ScriptUtils.deserializeResult(reader, it);
            if (value != null) {
                return value;
            }
            throw new InvalidDataAccessApiUsageException("Deserialized script result is null");
        });
    }

    protected RedisSerializationContext.SerializationPair<K> keySerializer() {
        return this.serializationContext.getKeySerializationPair();
    }

    @Override
    private <T> Flux<T> execute(ReactiveRedisCallback<T> action) {
        Assert.notNull(action, "Callback object must not be null");
        ReactiveRedisConnectionFactory factory = this.getConnectionFactory();
        return Flux.usingWhen((Publisher)Mono.fromSupplier(factory::getReactiveConnection), action::doInRedis, ReactiveRedisConnection::closeLater);
    }

    public ReactiveRedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

