/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.util.List;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptExecutor;
import org.springframework.data.redis.core.script.ScriptUtils;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DefaultScriptExecutor<K>
implements ScriptExecutor<K> {
    private final RedisTemplate<K, ?> template;

    public DefaultScriptExecutor(RedisTemplate<K, ?> template) {
        this.template = template;
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        return this.execute(script, this.template.getValueSerializer(), this.template.getValueSerializer(), keys, args);
    }

    @Override
    public <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<K> keys, Object ... args) {
        return (T)this.template.execute(connection -> {
            int keySize;
            ReturnType returnType = ReturnType.fromJavaType(script.getResultType());
            byte[][] keysAndArgs = this.keysAndArgs(argsSerializer, keys, args);
            int n = keySize = keys != null ? keys.size() : 0;
            if (connection.isPipelined() || connection.isQueueing()) {
                connection.eval(this.scriptBytes(script), returnType, keySize, keysAndArgs);
                return null;
            }
            return this.eval(connection, script, returnType, keySize, keysAndArgs, resultSerializer);
        });
    }

    protected <T> T eval(RedisConnection connection, RedisScript<T> script, ReturnType returnType, int numKeys, byte[][] keysAndArgs, RedisSerializer<T> resultSerializer) {
        Object result;
        try {
            result = connection.evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
        }
        catch (Exception ex) {
            if (!ScriptUtils.exceptionContainsNoScriptError(ex)) {
                RuntimeException runtimeException;
                if (ex instanceof RuntimeException) {
                    RuntimeException runtimeException2 = (RuntimeException)ex;
                    runtimeException = runtimeException2;
                } else {
                    runtimeException = new RedisSystemException(ex.getMessage(), ex);
                }
                throw runtimeException;
            }
            result = connection.eval(this.scriptBytes(script), returnType, numKeys, keysAndArgs);
        }
        if (script.getResultType() == null) {
            return null;
        }
        return this.deserializeResult(resultSerializer, result);
    }

    protected byte[][] keysAndArgs(RedisSerializer argsSerializer, List<K> keys, Object[] args) {
        int keySize = keys != null ? keys.size() : 0;
        byte[][] keysAndArgs = new byte[args.length + keySize][];
        int i = 0;
        if (keys != null) {
            for (Object key : keys) {
                if (this.keySerializer() == null && key instanceof byte[]) {
                    byte[] keyBytes = (byte[])key;
                    keysAndArgs[i++] = keyBytes;
                    continue;
                }
                keysAndArgs[i++] = this.keySerializer().serialize(key);
            }
        }
        for (Object arg : args) {
            if (argsSerializer == null && arg instanceof byte[]) {
                byte[] argBytes = (byte[])arg;
                keysAndArgs[i++] = argBytes;
                continue;
            }
            keysAndArgs[i++] = argsSerializer.serialize(arg);
        }
        return keysAndArgs;
    }

    protected byte[] scriptBytes(RedisScript<?> script) {
        return this.template.getStringSerializer().serialize(script.getScriptAsString());
    }

    protected <T> T deserializeResult(RedisSerializer<T> resultSerializer, Object result) {
        return ScriptUtils.deserializeResult(resultSerializer, result);
    }

    protected RedisSerializer keySerializer() {
        return this.template.getKeySerializer();
    }
}

