/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TimerListener;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;

public final class DefaultPeriodTaskScheduler
extends TimerListenerManager
implements PeriodTaskScheduler {
    @Override
    public void schedulePeriodTask(Runnable task, long period) {
        this.addTimerListener(new PeriodicTaskWrapper(task, period));
    }

    @Override
    public void scheduledTask(Runnable task) {
        this.addTimerListener(new TaskWrapper(task));
    }

    @Override
    public <T> T getTaskByType(Class<T> type) {
        for (TimerListener listener : this.getListeners()) {
            Object task = listener;
            if (listener instanceof TaskWrapper) {
                TaskWrapper wrapper = (TaskWrapper)listener;
                task = wrapper.getTask();
            }
            if (!type.isInstance(task)) continue;
            return type.cast(task);
        }
        return null;
    }

    @Override
    public void addTimerListener(TimerListener listener) {
        if (!(listener instanceof TaskWrapper)) {
            throw new IllegalArgumentException("Use the schedulePeriodTask or scheduledTask methods");
        }
        super.addTimerListener(listener);
    }

    private final class PeriodicTaskWrapper
    extends TaskWrapper {
        private final StopWatch watch;
        private final long period;

        public PeriodicTaskWrapper(Runnable task, long period) {
            super(task);
            this.watch = new StopWatch();
            this.period = period;
        }

        @Override
        public void onTimer() {
            if (this.watch.taken() > this.period) {
                this.watch.restart();
                this.task.run();
            }
        }
    }

    private class TaskWrapper
    extends ServiceSupport
    implements TimerListener {
        final Runnable task;
        private ExecutorService executorService;
        private Future running;

        public TaskWrapper(Runnable task) {
            this.task = task;
        }

        @Override
        public void onTimer() {
            if (this.running == null) {
                this.running = this.executorService.submit(this.task);
            }
        }

        public Runnable getTask() {
            return this.task;
        }

        @Override
        protected void doBuild() throws Exception {
            CamelContextAware.trySetCamelContext(this.task, DefaultPeriodTaskScheduler.this.getCamelContext());
            ServiceHelper.buildService((Object)this.task);
        }

        @Override
        protected void doInit() throws Exception {
            this.executorService = DefaultPeriodTaskScheduler.this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(this, this.task.getClass().getSimpleName());
            ServiceHelper.initService((Object)this.task);
        }

        @Override
        protected void doStart() throws Exception {
            ServiceHelper.startService((Object)this.task);
        }

        @Override
        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.task);
            DefaultPeriodTaskScheduler.this.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
            this.running = null;
        }

        @Override
        protected void doShutdown() throws Exception {
            ServiceHelper.stopAndShutdownService(this.task);
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

