/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationObservationContext;
import org.springframework.security.authorization.AuthorizationObservationConvention;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class ObservationReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T>,
MethodAuthorizationDeniedHandler {
    private final ObservationRegistry registry;
    private final ReactiveAuthorizationManager<T> delegate;
    private ObservationConvention<AuthorizationObservationContext<?>> convention = new AuthorizationObservationConvention();
    private MethodAuthorizationDeniedHandler handler = new ThrowingMethodAuthorizationDeniedHandler();

    public ObservationReactiveAuthorizationManager(ObservationRegistry registry, ReactiveAuthorizationManager<T> delegate) {
        this.registry = registry;
        this.delegate = delegate;
        if (delegate instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler h;
            this.handler = h = (MethodAuthorizationDeniedHandler)((Object)delegate);
        }
    }

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, T object) {
        AuthorizationObservationContext context = new AuthorizationObservationContext(object);
        Mono wrapped = authentication.map(auth -> {
            context.setAuthentication((Authentication)auth);
            return context.getAuthentication();
        });
        return Mono.deferContextual(contextView -> {
            Observation observation = Observation.createNotStarted(this.convention, () -> context, this.registry).parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return this.delegate.check((Mono<Authentication>)wrapped, object).doOnSuccess(decision -> {
                context.setDecision((AuthorizationDecision)decision);
                if (decision == null || !decision.isGranted()) {
                    observation.error(new AccessDeniedException("Access Denied"));
                }
                observation.stop();
            }).doOnCancel(observation::stop).doOnError(t -> {
                observation.error((Throwable)t);
                observation.stop();
            });
        });
    }

    public void setObservationConvention(ObservationConvention<AuthorizationObservationContext<?>> convention) {
        Assert.notNull(convention, "The observation convention cannot be null");
        this.convention = convention;
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

