/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.ArrayList;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationAdvisorProxyFactory;
import org.springframework.security.authorization.method.AuthorizeReturnObjectMethodInterceptor;
import org.springframework.security.config.Customizer;

@Configuration(proxyBeanMethods=false)
final class AuthorizationProxyConfiguration
implements AopInfrastructureBean {
    AuthorizationProxyConfiguration() {
    }

    @Bean
    @Role(value=2)
    static AuthorizationAdvisorProxyFactory authorizationProxyFactory(ObjectProvider<AuthorizationAdvisor> provider, ObjectProvider<Customizer<AuthorizationAdvisorProxyFactory>> customizers) {
        ArrayList<AuthorizationAdvisor> advisors = new ArrayList<AuthorizationAdvisor>();
        provider.forEach(advisors::add);
        AuthorizationAdvisorProxyFactory factory = AuthorizationAdvisorProxyFactory.withDefaults();
        customizers.forEach(c -> c.customize(factory));
        factory.setAdvisors(advisors);
        return factory;
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor authorizeReturnObjectMethodInterceptor(ObjectProvider<AuthorizationAdvisor> provider, AuthorizationAdvisorProxyFactory authorizationProxyFactory) {
        AuthorizeReturnObjectMethodInterceptor interceptor = new AuthorizeReturnObjectMethodInterceptor(authorizationProxyFactory);
        ArrayList<AuthorizationAdvisor> advisors = new ArrayList<AuthorizationAdvisor>();
        provider.forEach(advisors::add);
        advisors.add(interceptor);
        authorizationProxyFactory.setAdvisors(advisors);
        return interceptor;
    }
}

