/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterChainMapBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    @Override
    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        BeanDefinition filterChainProxy = holder.getBeanDefinition();
        ManagedList<BeanDefinition> securityFilterChains = new ManagedList<BeanDefinition>();
        Element elt = (Element)node;
        MatcherType matcherType = MatcherType.fromElementOrMvc(elt);
        List<Element> filterChainElts = DomUtils.getChildElementsByTagName(elt, "filter-chain");
        for (Element chain : filterChainElts) {
            String path = chain.getAttribute("pattern");
            String filters = chain.getAttribute("filters");
            if (!StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("The attribute 'pattern' must not be empty", elt);
            }
            if (!StringUtils.hasText(filters)) {
                parserContext.getReaderContext().error("The attribute 'filters'must not be empty", elt);
            }
            BeanDefinition matcher = matcherType.createMatcher(parserContext, path, null);
            if (filters.equals("none")) {
                securityFilterChains.add(this.createSecurityFilterChain(matcher, new ManagedList(0)));
                continue;
            }
            String[] filterBeanNames = StringUtils.tokenizeToStringArray(filters, ",");
            ManagedList<RuntimeBeanReference> filterChain = new ManagedList<RuntimeBeanReference>(filterBeanNames.length);
            for (String name : filterBeanNames) {
                filterChain.add(new RuntimeBeanReference(name));
            }
            securityFilterChains.add(this.createSecurityFilterChain(matcher, filterChain));
        }
        filterChainProxy.getConstructorArgumentValues().addGenericArgumentValue(securityFilterChains);
        return holder;
    }

    private BeanDefinition createSecurityFilterChain(BeanDefinition matcher, ManagedList<?> filters) {
        BeanDefinitionBuilder sfc = BeanDefinitionBuilder.rootBeanDefinition(DefaultSecurityFilterChain.class);
        sfc.addConstructorArgValue(matcher);
        sfc.addConstructorArgValue(filters);
        return sfc.getBeanDefinition();
    }
}

