/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntPredicateProxy;

public class QueryReader {
    private QueryReader() {
    }

    public static String readSourceQuery(Configuration config, StreamSource ss, IntPredicateProxy charChecker) throws XPathException {
        String queryText;
        if (ss.getInputStream() != null) {
            InputStream is = ss.getInputStream();
            is = InputStreamMarker.ensureMarkSupported(is);
            String encoding = QueryReader.readEncoding(is);
            queryText = QueryReader.readInputStream(is, encoding, charChecker);
        } else if (ss.getReader() != null) {
            queryText = QueryReader.readQueryFromReader(ss.getReader(), charChecker);
        } else if (ss.getSystemId() != null) {
            try {
                InputStream stream = ResourceLoader.urlStream(config, ss.getSystemId());
                stream = InputStreamMarker.ensureMarkSupported(stream);
                String encoding = QueryReader.readEncoding(stream);
                queryText = QueryReader.readInputStream(stream, encoding, charChecker);
            }
            catch (IOException e) {
                throw new XPathException("I/O Error reading input stream from " + ss.getSystemId(), e);
            }
        } else {
            throw new XPathException("Module URI Resolver must supply either an InputStream or a Reader");
        }
        return queryText.toString();
    }

    public static String readEncoding(InputStream is) throws XPathException {
        try {
            InputStreamMarker marker = new InputStreamMarker(is);
            if (!marker.isMarkSupported()) {
                throw new IllegalArgumentException("InputStream must have markSupported() = true");
            }
            marker.mark(100);
            byte[] start = new byte[100];
            int read = is.read(start, 0, 100);
            if (read == -1) {
                throw new XPathException("Query source file is empty");
            }
            marker.reset();
            return QueryReader.inferEncoding(start, read);
        }
        catch (IOException e) {
            throw new XPathException("Failed to read query source file", e);
        }
    }

    public static String readInputStream(InputStream is, String encoding, IntPredicateProxy nameChecker) throws XPathException {
        if (encoding == null) {
            is = InputStreamMarker.ensureMarkSupported(is);
            encoding = QueryReader.readEncoding(is);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            return QueryReader.readQueryFromReader(reader, nameChecker);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException err = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            err.setErrorCode("XQST0087");
            throw err;
        }
    }

    private static String readQueryFromReader(Reader reader, IntPredicateProxy charChecker) throws XPathException {
        try {
            UnicodeString content = UnparsedTextFunction.readFile(charChecker, reader);
            return content.toString();
        }
        catch (XPathException err) {
            err.setErrorCode("XPST0003");
            err.setIsStaticError(true);
            throw err;
        }
        catch (IOException ioErr) {
            throw new XPathException("Failed to read supplied query file", ioErr);
        }
    }

    private static String inferEncoding(byte[] start, int read) throws XPathException {
        if (read >= 2) {
            if (QueryReader.ch(start[0]) == '\u00fe' && QueryReader.ch(start[1]) == '\u00ff') {
                return "UTF-16";
            }
            if (QueryReader.ch(start[0]) == '\u00ff' && QueryReader.ch(start[1]) == '\u00fe') {
                return "UTF-16LE";
            }
        }
        if (read >= 3 && QueryReader.ch(start[0]) == '\u00ef' && QueryReader.ch(start[1]) == '\u00bb' && QueryReader.ch(start[2]) == '\u00bf') {
            return "UTF-8";
        }
        if (read >= 8 && start[0] == 0 && start[2] == 0 && start[4] == 0 && start[6] == 0) {
            return "UTF-16";
        }
        if (read >= 8 && start[1] == 0 && start[3] == 0 && start[5] == 0 && start[7] == 0) {
            return "UTF-16LE";
        }
        int i2 = 0;
        String tok = QueryReader.readToken(start, i2, read);
        if (Whitespace.trim(tok).equals("xquery")) {
            i2 += tok.length();
        } else {
            return "UTF-8";
        }
        tok = QueryReader.readToken(start, i2, read);
        if (Whitespace.trim(tok).equals("encoding")) {
            i2 += tok.length();
        } else {
            if (Whitespace.trim(tok).equals("version")) {
                i2 += tok.length();
            } else {
                return "UTF-8";
            }
            tok = QueryReader.readToken(start, i2, read);
            i2 += tok.length();
            tok = QueryReader.readToken(start, i2, read);
            if (Whitespace.trim(tok).equals("encoding")) {
                i2 += tok.length();
            } else {
                return "UTF-8";
            }
        }
        tok = Whitespace.trim(QueryReader.readToken(start, i2, read));
        if (tok.startsWith("\"") && tok.endsWith("\"") && tok.length() > 2) {
            return tok.substring(1, tok.length() - 1);
        }
        if (tok.startsWith("'") && tok.endsWith("'") && tok.length() > 2) {
            return tok.substring(1, tok.length() - 1);
        }
        throw new XPathException("Unrecognized encoding " + Err.wrap(tok) + " in query prolog");
    }

    private static String readToken(byte[] in, int i2, int len) {
        int p;
        for (p = i2; p < len && " \n\r\t".indexOf(QueryReader.ch(in[p])) >= 0; ++p) {
        }
        if (QueryReader.ch(in[p]) == '\"') {
            ++p;
            while (p < len && QueryReader.ch(in[p]) != '\"') {
                ++p;
            }
        } else if (QueryReader.ch(in[p]) == '\'') {
            ++p;
            while (p < len && QueryReader.ch(in[p]) != '\'') {
                ++p;
            }
        } else {
            while (p < len && " \n\r\t".indexOf(QueryReader.ch(in[p])) < 0) {
                ++p;
            }
        }
        if (p >= len) {
            return QueryReader.fromAsciiByteArray(in, i2, len - i2);
        }
        StringBuilder sb = new StringBuilder(p - i2 + 1);
        for (int c = i2; c <= p; ++c) {
            sb.append(QueryReader.ch(in[c]));
        }
        return sb.toString();
    }

    private static String fromAsciiByteArray(byte[] bytes, int start, int length) {
        return new String(bytes, start, length);
    }

    private static char ch(byte b) {
        return (char)(b & 0xFF);
    }
}

