/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Arrays;
import java.util.function.IntPredicate;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Slice24;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Twine24
extends UnicodeString {
    protected byte[] bytes;
    protected int cachedHash = 0;

    protected Twine24(byte[] bytes) {
        this.bytes = bytes;
    }

    public Twine24(int[] codePoints, int used) {
        this.bytes = new byte[used * 3];
        int i2 = 0;
        int j = 0;
        while (i2 < used) {
            int c = codePoints[i2];
            this.bytes[j] = (byte)(c >> 16 & 0xFF);
            this.bytes[j + 1] = (byte)(c >> 8 & 0xFF);
            this.bytes[j + 2] = (byte)(c & 0xFF);
            ++i2;
            j += 3;
        }
    }

    public Twine24(int[] codePoints) {
        this(codePoints, codePoints.length);
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    @Override
    public long length() {
        return this.bytes.length / 3;
    }

    @Override
    public int length32() {
        return this.bytes.length / 3;
    }

    @Override
    public UnicodeString substring(long start, long end) {
        int start32 = Twine24.requireInt(start);
        int end32 = Twine24.requireInt(end);
        int len = this.length32();
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        if (start == 0L && end == (long)len) {
            return this;
        }
        return new Slice24(this.bytes, start32, end32);
    }

    @Override
    public int codePointAt(long index) throws IndexOutOfBoundsException {
        int index32 = Twine24.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        int offset = index32 * 3;
        return (this.bytes[offset] << 16 | (this.bytes[offset + 1] & 0xFF) << 8 | this.bytes[offset + 2] & 0xFF) & 0xFFFFFF;
    }

    @Override
    public long indexOf(int code, long from) {
        int from32 = Twine24.requireNonNegativeInt(from);
        if (from32 >= this.length32()) {
            return -1L;
        }
        int last = this.bytes.length;
        if (code < 0 || code > 0xFFFFFF) {
            return -1L;
        }
        byte a = (byte)(code >> 16 & 0xFF);
        byte b = (byte)(code >> 8 & 0xFF);
        byte c = (byte)(code & 0xFF);
        for (int i2 = from32 * 3; i2 < last; i2 += 3) {
            if (this.bytes[i2 + 2] != c || this.bytes[i2 + 1] != b || this.bytes[i2] != a) continue;
            return i2 / 3;
        }
        return -1L;
    }

    @Override
    public long indexOf(UnicodeString other, long from) {
        int from32 = Twine24.requireInt(from);
        if (from32 < 0) {
            from32 = 0;
        } else if (from32 >= this.length32()) {
            return -1L;
        }
        if (other.isEmpty()) {
            return from;
        }
        int initial = other.codePointAt(0L);
        int len = Twine24.requireInt(other.length());
        int lastPossible = this.length32() - len;
        while (from32 <= lastPossible) {
            int i2 = Twine24.requireInt(this.indexOf(initial, (long)from32));
            if (i2 < 0) {
                return -1L;
            }
            if (this.hasSubstring(other, i2)) {
                return i2;
            }
            from32 = i2 + 1;
        }
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    @Override
    public int getWidth() {
        return 24;
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Twine24.this.bytes.length;
            }

            @Override
            public int next() {
                int result = (Twine24.this.bytes[this.i] & 0xFF) << 16 | (Twine24.this.bytes[this.i + 1] & 0xFF) << 8 | Twine24.this.bytes[this.i + 2] & 0xFF;
                this.i += 3;
                return result;
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h = 0;
        int end = this.bytes.length;
        for (int i2 = 0; i2 < end; i2 += 3) {
            int cp = (this.bytes[i2] << 16 | (this.bytes[i2 + 1] & 0xFF) << 8 | this.bytes[i2 + 2] & 0xFF) & 0xFFFFFF;
            if ((cp & 0xFF0000) != 0) {
                h = 31 * h + UTF16CharacterSet.highSurrogate(cp);
                h = 31 * h + UTF16CharacterSet.lowSurrogate(cp);
                continue;
            }
            h = 31 * h + cp;
        }
        this.cachedHash = h;
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Twine24) {
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            return Arrays.equals(this.bytes, ((Twine24)o).bytes);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (other instanceof Twine24) {
            Twine24 o = (Twine24)other;
            byte[] a = this.bytes;
            byte[] b = o.bytes;
            int len = Math.min(a.length, b.length);
            for (int i2 = 0; i2 < len; ++i2) {
                int diff = (a[i2] & 0xFF) - (b[i2] & 0xFF);
                if (diff == 0) continue;
                return diff;
            }
            return Integer.compare(a.length, b.length);
        }
        return super.compareTo(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length32());
        IntIterator iter = this.codePoints();
        while (iter.hasNext()) {
            int x = iter.next();
            sb.appendCodePoint(x);
        }
        return sb.toString();
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        int i2 = Twine24.requireNonNegativeInt(from);
        while ((long)i2 < this.length()) {
            int offset = i2 * 3;
            int cp = (this.bytes[offset] << 16 | (this.bytes[offset + 1] & 0xFF) << 8 | this.bytes[offset + 2] & 0xFF) & 0xFFFFFF;
            if (predicate.test(cp)) {
                return i2;
            }
            ++i2;
        }
        return -1L;
    }

    public String details() {
        return "Twine24 bytes.length = " + this.bytes.length;
    }
}

