/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.TypeConvertible;

@DeferredContextBinding
public final class StreamCacheBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public int size() {
        return 6;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters(this);
        this.doRegistration(registry);
    }

    @Override
    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange2, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange2, value);
            if (obj == Void.class) {
                return null;
            }
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange2, Object value) throws Exception {
        if (to == byte[].class) {
            if (value instanceof StreamCache) {
                return StreamCacheConverter.convertToByteArray((StreamCache)value, exchange2);
            }
        } else if (to == ByteBuffer.class) {
            if (value instanceof StreamCache) {
                return StreamCacheConverter.convertToByteBuffer((StreamCache)value, exchange2);
            }
        } else if (to == StreamCache.class) {
            if (value instanceof ByteArrayInputStream) {
                return StreamCacheConverter.convertToStreamCache((ByteArrayInputStream)value, exchange2);
            }
            if (value instanceof InputStream) {
                return StreamCacheConverter.convertToStreamCache((InputStream)value, exchange2);
            }
            if (value instanceof CachedOutputStream) {
                return StreamCacheConverter.convertToStreamCache((CachedOutputStream)value, exchange2);
            }
            if (value instanceof Reader) {
                return StreamCacheConverter.convertToStreamCache((Reader)value, exchange2);
            }
        }
        return null;
    }

    private void doRegistration(TypeConverterRegistry registry) {
        registry.addConverter(new TypeConvertible<StreamCache, byte[]>(StreamCache.class, byte[].class), this);
        registry.addConverter(new TypeConvertible<StreamCache, ByteBuffer>(StreamCache.class, ByteBuffer.class), this);
        registry.addConverter(new TypeConvertible<ByteArrayInputStream, StreamCache>(ByteArrayInputStream.class, StreamCache.class), this);
        registry.addConverter(new TypeConvertible<InputStream, StreamCache>(InputStream.class, StreamCache.class), this);
        registry.addConverter(new TypeConvertible<CachedOutputStream, StreamCache>(CachedOutputStream.class, StreamCache.class), this);
        registry.addConverter(new TypeConvertible<Reader, StreamCache>(Reader.class, StreamCache.class), this);
    }

    @Override
    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == byte[].class) {
            if (from == StreamCache.class) {
                return this;
            }
        } else if (to == ByteBuffer.class) {
            if (from == StreamCache.class) {
                return this;
            }
        } else if (to == StreamCache.class) {
            if (from == ByteArrayInputStream.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == CachedOutputStream.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
        }
        return null;
    }
}

