/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.processor.ConvertBodyProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.SynchronousExecutorService;

public class DefaultProducerTemplate
extends ServiceSupport
implements ProducerTemplate {
    private final CamelContext camelContext;
    private volatile ProducerCache producerCache;
    private volatile ExecutorService executor;
    private Endpoint defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled = true;
    private volatile boolean threadedAsyncMode = true;

    public DefaultProducerTemplate(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DefaultProducerTemplate(CamelContext camelContext, ExecutorService executor) {
        this.camelContext = camelContext;
        this.executor = executor;
    }

    public DefaultProducerTemplate(CamelContext camelContext, Endpoint defaultEndpoint) {
        this(camelContext);
        this.defaultEndpoint = defaultEndpoint;
    }

    public static DefaultProducerTemplate newInstance(CamelContext camelContext, String defaultEndpointUri) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, defaultEndpointUri);
        return new DefaultProducerTemplate(camelContext, endpoint);
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public boolean isThreadedAsyncMode() {
        return this.threadedAsyncMode;
    }

    @Override
    public void setThreadedAsyncMode(boolean useExecutor) {
        this.threadedAsyncMode = useExecutor;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.producerCache == null) {
            return 0;
        }
        return this.producerCache.size();
    }

    @Override
    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    @Override
    public void cleanUp() {
        if (this.producerCache != null) {
            this.producerCache.cleanUp();
        }
    }

    @Override
    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
        if (this.producerCache != null) {
            this.producerCache.setEventNotifierEnabled(eventNotifierEnabled);
        }
    }

    @Override
    public Exchange send(String endpointUri, Exchange exchange2) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, exchange2);
    }

    @Override
    public Exchange send(String endpointUri, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, null, processor, null);
    }

    @Override
    public Exchange send(String endpointUri, ExchangePattern pattern, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, pattern, processor, null);
    }

    @Override
    public Exchange send(Endpoint endpoint, Exchange exchange2) {
        return this.send(endpoint, exchange2, null);
    }

    @Override
    public Exchange send(Endpoint endpoint, Processor processor) {
        return this.send(endpoint, null, processor, null);
    }

    @Override
    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        return this.send(endpoint, pattern, processor, null);
    }

    @Override
    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor) {
        Exchange exchange2;
        Exchange exchange3 = exchange2 = pattern != null ? endpoint.createExchange(pattern) : endpoint.createExchange();
        if (processor != null) {
            try {
                processor.process(exchange2);
            }
            catch (Exception e) {
                exchange2.setException(e);
                return exchange2;
            }
        }
        return this.send(endpoint, exchange2, resultProcessor);
    }

    public Exchange send(Endpoint endpoint, Exchange exchange2, Processor resultProcessor) {
        return this.getProducerCache().send(endpoint, exchange2, resultProcessor);
    }

    @Override
    public Object sendBody(Endpoint endpoint, ExchangePattern pattern, Object body2) {
        Exchange result = this.send(endpoint, pattern, this.createSetBodyProcessor(body2));
        return this.extractResultBody(result, pattern);
    }

    @Override
    public void sendBody(Endpoint endpoint, Object body2) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createSetBodyProcessor(body2));
        this.extractResultBody(result);
    }

    @Override
    public void sendBody(String endpointUri, Object body2) throws CamelExecutionException {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        this.sendBody(endpoint, body2);
    }

    @Override
    public Object sendBody(String endpointUri, ExchangePattern pattern, Object body2) throws CamelExecutionException {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Object result = this.sendBody(endpoint, pattern, body2);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public void sendBodyAndHeader(String endpointUri, Object body2, String header, Object headerValue) throws CamelExecutionException {
        this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body2, header, headerValue);
    }

    @Override
    public void sendBodyAndHeader(Endpoint endpoint, Object body2, String header, Object headerValue) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndHeaderProcessor(body2, header, headerValue));
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndHeader(Endpoint endpoint, ExchangePattern pattern, Object body2, String header, Object headerValue) throws CamelExecutionException {
        Exchange exchange2 = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body2, header, headerValue));
        Object result = this.extractResultBody(exchange2, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public Object sendBodyAndHeader(String endpoint, ExchangePattern pattern, Object body2, String header, Object headerValue) throws CamelExecutionException {
        Exchange exchange2 = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body2, header, headerValue));
        Object result = this.extractResultBody(exchange2, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public void sendBodyAndProperty(String endpointUri, Object body2, String property, Object propertyValue) throws CamelExecutionException {
        this.sendBodyAndProperty(this.resolveMandatoryEndpoint(endpointUri), body2, property, propertyValue);
    }

    @Override
    public void sendBodyAndProperty(Endpoint endpoint, Object body2, String property, Object propertyValue) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndPropertyProcessor(body2, property, propertyValue));
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndProperty(Endpoint endpoint, ExchangePattern pattern, Object body2, String property, Object propertyValue) throws CamelExecutionException {
        Exchange exchange2 = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body2, property, propertyValue));
        Object result = this.extractResultBody(exchange2, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public Object sendBodyAndProperty(String endpoint, ExchangePattern pattern, Object body2, String property, Object propertyValue) throws CamelExecutionException {
        Exchange exchange2 = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body2, property, propertyValue));
        Object result = this.extractResultBody(exchange2, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public void sendBodyAndHeaders(String endpointUri, Object body2, Map<String, Object> headers) throws CamelExecutionException {
        this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body2, headers);
    }

    @Override
    public void sendBodyAndHeaders(Endpoint endpoint, Object body2, Map<String, Object> headers) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndHeaders(body2, headers));
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndHeaders(String endpointUri, ExchangePattern pattern, Object body2, Map<String, Object> headers) throws CamelExecutionException {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), pattern, body2, headers);
    }

    @Override
    public Object sendBodyAndHeaders(Endpoint endpoint, ExchangePattern pattern, Object body2, Map<String, Object> headers) throws CamelExecutionException {
        Exchange exchange2 = this.send(endpoint, pattern, this.createBodyAndHeaders(body2, headers));
        Object result = this.extractResultBody(exchange2, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    @Override
    public Exchange request(Endpoint endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    @Override
    public Object requestBody(Object body2) throws CamelExecutionException {
        return this.sendBody(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body2);
    }

    @Override
    public Object requestBody(Endpoint endpoint, Object body2) throws CamelExecutionException {
        return this.sendBody(endpoint, ExchangePattern.InOut, body2);
    }

    @Override
    public Object requestBodyAndHeader(Object body2, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body2, header, headerValue);
    }

    @Override
    public Object requestBodyAndHeader(Endpoint endpoint, Object body2, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body2, header, headerValue);
    }

    @Override
    public Exchange request(String endpointUri, Processor processor) throws CamelExecutionException {
        return this.send(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, processor, null);
    }

    @Override
    public Object requestBody(String endpointUri, Object body2) throws CamelExecutionException {
        return this.sendBody(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body2);
    }

    @Override
    public Object requestBodyAndHeader(String endpointUri, Object body2, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body2, header, headerValue);
    }

    @Override
    public Object requestBodyAndHeaders(String endpointUri, Object body2, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body2, headers);
    }

    @Override
    public Object requestBodyAndHeaders(Endpoint endpoint, Object body2, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(endpoint, ExchangePattern.InOut, body2, headers);
    }

    @Override
    public Object requestBodyAndHeaders(Object body2, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body2, headers);
    }

    @Override
    public <T> T requestBody(Object body2, Class<T> type) {
        return this.requestBody(this.getMandatoryDefaultEndpoint(), body2, type);
    }

    @Override
    public <T> T requestBody(Endpoint endpoint, Object body2, Class<T> type) {
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createSetBodyProcessor(body2), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBody(String endpointUri, Object body2, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createSetBodyProcessor(body2), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeader(Endpoint endpoint, Object body2, String header, Object headerValue, Class<T> type) {
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaderProcessor(body2, header, headerValue), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeader(String endpointUri, Object body2, String header, Object headerValue, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaderProcessor(body2, header, headerValue), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeaders(String endpointUri, Object body2, Map<String, Object> headers, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaders(body2, headers), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeaders(Endpoint endpoint, Object body2, Map<String, Object> headers, Class<T> type) {
        Exchange exchange2 = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaders(body2, headers), new ConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange2);
        return this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public void sendBody(Object body2) {
        this.sendBody(this.getMandatoryDefaultEndpoint(), body2);
    }

    @Override
    public Exchange send(Exchange exchange2) {
        return this.send(this.getMandatoryDefaultEndpoint(), exchange2);
    }

    @Override
    public Exchange send(Processor processor) {
        return this.send(this.getMandatoryDefaultEndpoint(), processor);
    }

    @Override
    public void sendBodyAndHeader(Object body2, String header, Object headerValue) {
        this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), body2, header, headerValue);
    }

    @Override
    public void sendBodyAndProperty(Object body2, String property, Object propertyValue) {
        this.sendBodyAndProperty(this.getMandatoryDefaultEndpoint(), body2, property, propertyValue);
    }

    @Override
    public void sendBodyAndHeaders(Object body2, Map<String, Object> headers) {
        this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), body2, headers);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    @Override
    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    protected Processor createBodyAndHeaderProcessor(final Object body2, final String header, final Object headerValue) {
        return new Processor(){

            @Override
            public void process(Exchange exchange2) {
                Message in = exchange2.getIn();
                in.setHeader(header, headerValue);
                in.setBody(body2);
            }
        };
    }

    protected Processor createBodyAndHeaders(final Object body2, final Map<String, Object> headers) {
        return new Processor(){

            @Override
            public void process(Exchange exchange2) {
                Message in = exchange2.getIn();
                if (headers != null) {
                    for (Map.Entry header : headers.entrySet()) {
                        in.setHeader((String)header.getKey(), header.getValue());
                    }
                }
                in.setBody(body2);
            }
        };
    }

    protected Processor createBodyAndPropertyProcessor(final Object body2, final String property, final Object propertyValue) {
        return new Processor(){

            @Override
            public void process(Exchange exchange2) {
                exchange2.setProperty(property, propertyValue);
                Message in = exchange2.getIn();
                in.setBody(body2);
            }
        };
    }

    protected Processor createSetBodyProcessor(final Object body2) {
        return new Processor(){

            @Override
            public void process(Exchange exchange2) {
                Message in = exchange2.getIn();
                in.setBody(body2);
            }
        };
    }

    protected Function<Exchange, Exchange> createCompletionFunction(Synchronization onCompletion) {
        return answer -> {
            if (answer.isFailed()) {
                onCompletion.onFailure((Exchange)answer);
            } else {
                onCompletion.onComplete((Exchange)answer);
            }
            return answer;
        };
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        Endpoint endpoint = this.camelContext.getEndpoint(endpointUri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(endpointUri);
        }
        return endpoint;
    }

    protected Endpoint getMandatoryDefaultEndpoint() {
        Endpoint answer = this.getDefaultEndpoint();
        ObjectHelper.notNull(answer, "defaultEndpoint");
        return answer;
    }

    protected Object extractResultBody(Exchange result) {
        return this.extractResultBody(result, null);
    }

    protected Object extractResultBody(Exchange result, ExchangePattern pattern) {
        return ExchangeHelper.extractResultBody(result, pattern);
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public CompletableFuture<Exchange> asyncSend(String uri, Exchange exchange2) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), exchange2);
    }

    @Override
    public CompletableFuture<Exchange> asyncSend(String uri, Processor processor) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), processor);
    }

    @Override
    public CompletableFuture<Object> asyncSendBody(String uri, Object body2) {
        return this.asyncSendBody(this.resolveMandatoryEndpoint(uri), body2);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBody(String uri, Object body2) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), body2);
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBody(String uri, Object body2, Class<T> type) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), this.createSetBodyProcessor(body2), type);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBodyAndHeader(String endpointUri, Object body2, String header, Object headerValue) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body2, header, headerValue);
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBodyAndHeader(String endpointUri, Object body2, String header, Object headerValue, Class<T> type) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body2, header, headerValue, type);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBodyAndHeaders(String endpointUri, Object body2, Map<String, Object> headers) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body2, headers);
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBodyAndHeaders(String endpointUri, Object body2, Map<String, Object> headers, Class<T> type) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body2, headers, type);
    }

    @Override
    public <T> T extractFutureBody(Future<?> future, Class<T> type) {
        return ExchangeHelper.extractFutureBody(this.camelContext, future, type);
    }

    @Override
    public <T> T extractFutureBody(Future<?> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        return ExchangeHelper.extractFutureBody(this.camelContext, future, timeout, unit, type);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Object body2) {
        return this.asyncRequestBody(endpoint, this.createSetBodyProcessor(body2));
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBody(Endpoint endpoint, Object body2, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createSetBodyProcessor(body2), type);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBodyAndHeader(Endpoint endpoint, Object body2, String header, Object headerValue) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaderProcessor(body2, header, headerValue));
    }

    protected <T> CompletableFuture<T> asyncRequestBody(Endpoint endpoint, Processor processor, Class<T> type) {
        return this.asyncRequestBody(endpoint, processor, new ConvertBodyProcessor(type)).thenApply(answer -> this.camelContext.getTypeConverter().convertTo(type, answer));
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBodyAndHeader(Endpoint endpoint, Object body2, String header, Object headerValue, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaderProcessor(body2, header, headerValue), type);
    }

    @Override
    public CompletableFuture<Object> asyncRequestBodyAndHeaders(Endpoint endpoint, Object body2, Map<String, Object> headers) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaders(body2, headers));
    }

    @Override
    public <T> CompletableFuture<T> asyncRequestBodyAndHeaders(Endpoint endpoint, Object body2, Map<String, Object> headers, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaders(body2, headers), type);
    }

    @Override
    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, Exchange exchange2) {
        return this.asyncSendExchange(endpoint, null, null, null, exchange2);
    }

    @Override
    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, Processor processor) {
        return this.asyncSend(endpoint, null, processor, null);
    }

    @Override
    public CompletableFuture<Object> asyncSendBody(Endpoint endpoint, Object body2) {
        return this.asyncSend(endpoint, this.createSetBodyProcessor(body2)).thenApply(this::extractResultBody);
    }

    protected CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Processor processor) {
        return this.asyncRequestBody(endpoint, processor, (Processor)null);
    }

    protected CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Processor processor, Processor resultProcessor) {
        return this.asyncRequest(endpoint, processor, resultProcessor).thenApply(e -> this.extractResultBody((Exchange)e, ExchangePattern.InOut));
    }

    protected CompletableFuture<Exchange> asyncRequest(Endpoint endpoint, Processor processor, Processor resultProcessor) {
        return this.asyncSend(endpoint, ExchangePattern.InOut, processor, resultProcessor);
    }

    protected CompletableFuture<Exchange> asyncSend(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor) {
        return this.asyncSendExchange(endpoint, pattern, processor, resultProcessor, null);
    }

    protected CompletableFuture<Exchange> asyncSendExchange(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, Exchange inExchange) {
        CompletableFuture<Exchange> exchangeFuture = new CompletableFuture<Exchange>();
        this.getExecutorService().submit(() -> this.getProducerCache().asyncSendExchange(endpoint, pattern, processor, resultProcessor, inExchange, exchangeFuture));
        return exchangeFuture;
    }

    private ProducerCache getProducerCache() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ProducerTemplate has not been started");
        }
        return this.producerCache;
    }

    private ExecutorService getExecutorService() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ProducerTemplate has not been started");
        }
        if (this.executor == null) {
            this.lock.lock();
            try {
                if (this.executor == null) {
                    this.executor = this.threadedAsyncMode ? this.camelContext.getExecutorServiceManager().newDefaultThreadPool(this, "ProducerTemplate") : new SynchronousExecutorService();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.executor;
    }

    @Override
    protected void doBuild() throws Exception {
        this.producerCache = new DefaultProducerCache(this, this.camelContext, this.maximumCacheSize);
        this.producerCache.setEventNotifierEnabled(this.isEventNotifierEnabled());
        ServiceHelper.buildService((Object)this.producerCache);
    }

    @Override
    protected void doInit() throws Exception {
        if (this.defaultEndpoint != null) {
            this.defaultEndpoint = this.camelContext.getEndpoint(this.defaultEndpoint.getEndpointUri());
        }
        ServiceHelper.initService((Object)this.producerCache);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.producerCache);
        this.producerCache = null;
    }
}

