/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    public static final DefaultExceptionPolicyStrategy INSTANCE = new DefaultExceptionPolicyStrategy();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionPolicyStrategy.class);

    @Override
    public ExceptionPolicyKey getExceptionPolicy(Set<ExceptionPolicyKey> exceptionPolicies, Exchange exchange2, Throwable exception) {
        TreeMap<Integer, ExceptionPolicyKey> candidates = new TreeMap<Integer, ExceptionPolicyKey>();
        LinkedHashSet<ExceptionPolicyKey> routeScoped = new LinkedHashSet<ExceptionPolicyKey>();
        LinkedHashSet<ExceptionPolicyKey> contextScoped = new LinkedHashSet<ExceptionPolicyKey>();
        DefaultExceptionPolicyStrategy.initRouteAndContextScopedExceptionPolicies(exceptionPolicies, routeScoped, contextScoped);
        Iterable<Throwable> throwables = this.createExceptionIterable(exception);
        boolean exactMatch = false;
        Iterator<Throwable> it = throwables.iterator();
        while (!exactMatch && it.hasNext()) {
            exactMatch = this.findMatchedExceptionPolicy(routeScoped, exchange2, it.next(), candidates);
        }
        it = throwables.iterator();
        while (!exactMatch && it.hasNext()) {
            exactMatch = this.findMatchedExceptionPolicy(contextScoped, exchange2, it.next(), candidates);
        }
        LOG.trace("Found {} candidates", (Object)candidates.size());
        if (candidates.isEmpty()) {
            return null;
        }
        return (ExceptionPolicyKey)candidates.values().iterator().next();
    }

    private static void initRouteAndContextScopedExceptionPolicies(Set<ExceptionPolicyKey> exceptionPolicies, Set<ExceptionPolicyKey> routeScoped, Set<ExceptionPolicyKey> contextScoped) {
        for (ExceptionPolicyKey entry : exceptionPolicies) {
            if (entry.getRouteId() != null) {
                routeScoped.add(entry);
                continue;
            }
            contextScoped.add(entry);
        }
    }

    private boolean findMatchedExceptionPolicy(Iterable<ExceptionPolicyKey> exceptionPolicies, Exchange exchange2, Throwable exception, Map<Integer, ExceptionPolicyKey> candidates) {
        boolean exactMatch;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finding best suited exception policy for thrown exception {}", (Object)exception.getClass().getName());
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        ExceptionPolicyKey candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        for (ExceptionPolicyKey type : exceptionPolicies) {
            String route;
            Class<?> clazz = type.getExceptionClass();
            String typeRoute = type.getRouteId();
            if (exchange2 != null && ObjectHelper.isNotEmpty(typeRoute) && (route = ExchangeHelper.getRouteId(exchange2)) != null && !route.equals(typeRoute)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("The type is scoped for route: {} however Exchange is at route: {}", (Object)typeRoute, (Object)route);
                continue;
            }
            if (!this.filter(type, clazz, exception)) continue;
            if (!this.matchesWhen(type, exchange2)) {
                LOG.trace("The type did not match when: {}", (Object)type);
                continue;
            }
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                candidateDiff = 0;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (candidate != null) {
            if (!candidates.containsKey(candidateDiff)) {
                LOG.trace("Adding {} as candidate at level {}", candidate, (Object)candidateDiff);
                candidates.put(candidateDiff, candidate);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Existing candidate {} takes precedence over{} at level {}", new Object[]{candidates.get(candidateDiff), candidate, candidateDiff});
            }
        }
        boolean bl = exactMatch = candidateDiff == 0;
        if (LOG.isTraceEnabled() && exactMatch) {
            LOG.trace("Exact match found for candidate: {}", candidate);
        }
        return exactMatch;
    }

    protected boolean filter(ExceptionPolicyKey type, Class<?> exceptionClass, Throwable exception) {
        return exceptionClass.isInstance(exception);
    }

    protected boolean matchesWhen(ExceptionPolicyKey definition, Exchange exchange2) {
        if (definition.getWhen() == null) {
            return true;
        }
        return definition.getWhen().matches(exchange2);
    }

    protected Iterable<Throwable> createExceptionIterable(Throwable exception) {
        return ObjectHelper.createExceptionIterable(exception);
    }

    private static int getInheritanceLevel(Class<?> clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }
}

