/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.processor.Enricher;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EndpointHelper;

public class EnrichReifier
extends ExpressionReifier<EnrichDefinition> {
    public EnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (EnrichDefinition)EnrichDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        AggregationStrategy strategy;
        String uri;
        Expression exp;
        if (((EnrichDefinition)this.definition).getExpression() instanceof ConstantExpression) {
            exp = this.createExpression(((EnrichDefinition)this.definition).getExpression());
            DefaultExchange ex = new DefaultExchange(this.camelContext);
            uri = exp.evaluate(ex, String.class);
        } else {
            exp = this.createExpression(((EnrichDefinition)this.definition).getExpression());
            uri = ((EnrichDefinition)this.definition).getExpression().getExpression();
        }
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute(this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        }
        Enricher enricher = new Enricher(exp, uri);
        enricher.setVariableSend(this.parseString(((EnrichDefinition)this.definition).getVariableSend()));
        enricher.setVariableReceive(this.parseString(((EnrichDefinition)this.definition).getVariableReceive()));
        enricher.setShareUnitOfWork(this.parseBoolean(((EnrichDefinition)this.definition).getShareUnitOfWork(), false));
        enricher.setIgnoreInvalidEndpoint(this.parseBoolean(((EnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false));
        enricher.setAggregateOnException(this.parseBoolean(((EnrichDefinition)this.definition).getAggregateOnException(), false));
        Integer num = this.parseInt(((EnrichDefinition)this.definition).getCacheSize());
        if (num != null) {
            enricher.setCacheSize(num);
        }
        if ((strategy = this.getConfiguredAggregationStrategy((AggregationStrategyAwareDefinition)((Object)this.definition))) != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if (((EnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.parseBoolean(((EnrichDefinition)this.definition).getAggregateOnException(), false));
        }
        if (((EnrichDefinition)this.definition).getAllowOptimisedComponents() != null) {
            enricher.setAllowOptimisedComponents(this.parseBoolean(((EnrichDefinition)this.definition).getAllowOptimisedComponents(), true));
        }
        if (((EnrichDefinition)this.definition).getAutoStartComponents() != null) {
            enricher.setAutoStartupComponents(this.parseBoolean(((EnrichDefinition)this.definition).getAutoStartComponents(), true));
        }
        return enricher;
    }
}

