/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.UnitOfWorkHelper;

public class BridgeExceptionHandlerToErrorHandler
implements ExceptionHandler {
    private final LoggingExceptionHandler fallback;
    private final DefaultConsumer consumer;
    private final Processor bridge;

    public BridgeExceptionHandlerToErrorHandler(DefaultConsumer consumer) {
        this.consumer = consumer;
        this.fallback = new LoggingExceptionHandler(consumer.getEndpoint().getCamelContext(), consumer.getClass());
        this.bridge = consumer.getProcessor();
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(String message, Exchange exchange2, Throwable exception) {
        if (exchange2 == null) {
            exchange2 = this.consumer.getEndpoint().createExchange();
        }
        exchange2.setException(exception);
        exchange2.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)exception);
        exchange2.getIn().setBody(message);
        exchange2.setProperty(ExchangePropertyKey.ERRORHANDLER_BRIDGE, (Object)true);
        exchange2.getExchangeExtension().setRedeliveryExhausted(true);
        UnitOfWork uow = null;
        try {
            uow = this.consumer.createUoW(exchange2);
            this.bridge.process(exchange2);
        }
        catch (Exception e) {
            this.fallback.handleException("Error handling exception " + exception.getMessage(), exchange2, e);
        }
        finally {
            UnitOfWorkHelper.doneUow(uow, exchange2);
        }
    }
}

